import React, { useEffect, useState } from 'react';
import { TreeSelect } from 'antd';
import { loadTagCatalogTree } from '../../../../service/TagService';

export interface TreeSelectItemProps {
    value?: string | number;
    onChange?: (value: string | number) => void;
    placeholder?: string;
    multiple?: boolean; 
    style?: React.CSSProperties;
    resourceType:string;
    session:any;
    setSelectTags:any
    selectTags:any
}

const TreeSelectItem: React.FC<TreeSelectItemProps> = ({
    value,
    onChange,
    placeholder = '请选择',
    multiple = true,
    setSelectTags,
    selectTags,
    resourceType,
    session
}) => {
    const [treeData, setTreeData] = useState<any>([]);
    const [loading,setLoading] = useState(false)

    useEffect(() => {
        getAllTags()
    }, []);

    //获取所有标签
    const getAllTags = (bol=false) => {
        setLoading(true);
        loadTagCatalogTree({
            isDefault:false,
            withTagData: true,
            type: 'public',
            resourceType:resourceType,
            creator: session?.user?.userName||''
        }, (data:any) => {
            getPrivateTags(data?.data,bol);
        }, () => {
            setLoading(false);
        })
    }

    //目录树结构修改
    const newTreeData = (datas:any,type:any,parentkey=undefined)=>{
        try{
            let data:any = JSON.parse(JSON.stringify(datas))
            let newbox:any = []
            for(let node of data){
                let box:any = {
                    title: <div id={`catalog_${type}_${node.id}`}>
                        <div 
                            style={{
                            borderRadius:2,
                            height:14,
                            border:type==='public'?'2px solid #2db7f5':'2px solid #d4380d',
                            float:'left',
                            marginTop:5,
                            marginRight:4,
                            }}
                        />
                        <span style={{float:'left'}} >{node.name}</span>
                        </div>,
                    key: parentkey?`${parentkey},catalog_${type}_${node.id}`:`catalog_${type}_${node.id}`,
                    type: 'catalog',
                    isLeaf: false,
                    name:node.name,
                    value:`catalog_${type}_${node.id}`,
                    selectable:false,
                    children:[]
                }
                if(node.children&&node.children[0]){
                    let childrenBox = newTreeData(node.children,type,node.key)
                    box.children = childrenBox
                }
                if(node.tagNode&&node.tagNode[0]){
                    for(let item of node.tagNode){
                        box.children.push({
                            title: item.name,
                            key: item.id,
                            type: 'tag',
                            value:item.id,
                            isLeaf: true,
                            name:item.name
                        })
                    }
                }
                newbox.push(box)
            }
    
            return newbox
        }catch(err){
            console.log('err',err)
            return []
        }
    
    }


    //获取私有标签
    const getPrivateTags = (publicData:any,reflash=true) => {
        console.log(reflash)
        loadTagCatalogTree({
        isDefault:false,
        withTagData: true,
        type: 'private',
        resourceType:resourceType,
        creator: session?.user?.userName||''
        }, (data:any) => {
        setLoading(false);
        try{
            let _treeData:any = []; 
    
            if ((publicData?.children||[]).length>0) {
                let publicbox = newTreeData(publicData.children,'public')
                _treeData=_treeData.concat(publicbox)
            }

            if ((data?.data?.children||[]).length>0) {
                let privatebox = newTreeData(data.data.children,'private')
                _treeData=_treeData.concat(privatebox)
    
            }
            console.log(_treeData)
            setTreeData(_treeData);
        }catch(err){
            console.log('err',err)
        }

        }, () => {
            setLoading(false);
        })
    }



    return (
        <TreeSelect
            treeData={treeData}
            value={selectTags}
            placeholder={placeholder}
            onChange={(values)=>{setSelectTags(values)}}
            allowClear
            multiple={multiple}
            style={{width:'100%'}}
            showSearch
            treeNodeFilterProp="title"
            filterTreeNode={(input, node:any) =>{
                return node?.name?.toLowerCase().indexOf(input.toLowerCase()) >= 0
                // return node?.title?.props?.children?.[1]?.toLowerCase().indexOf(input.toLowerCase()) >= 0 ||
                // node?.title?.indexOf(input.toLowerCase()) >= 0
            }}
        />
    );
};

export default TreeSelectItem;