import React from 'react'
import { Modal, Spin, Descriptions } from 'antd'

import { dispatch } from '../../../../model'

const FC = (props) => {
  const { visible, id, onCancel } = props
  const [waiting, setWaiting] = React.useState(false)
  const [data, setData] = React.useState()

  React.useEffect(() => {
    if (visible && id) {
      getDetail()
    }
  }, [visible, id])

  const getDetail = () => {
    setWaiting(true)
    dispatch({
      type: 'datamodel.getUploadDDLResultDetails',
      payload: {
        easyDataModelerDataModelId: id,
      },
      callback: (data) => {
        setWaiting(false)
        setData(data)
      },
      error: () => {
        setWaiting(false)
      }
    })
  }

  const close = () => {
    setData()
    onCancel?.()
  }

  return (
    <Modal
      visible={visible}
      footer={null}
      width='80%'
      bodyStyle={{ padding: '15px', overflowX: 'auto', height: '80vh' }}
      title='DDL下发结果详情'
      centered destroyOnClose
      onCancel={() => { close() }}
    >
      <Spin spinning={waiting}>
        <Descriptions size='small' column={1}>
          <Descriptions.Item label='下发结果'>
          {data?.state}
          </Descriptions.Item>  
          <Descriptions.Item label='详细说明'>
          {data?.desc}
          </Descriptions.Item>  
          <Descriptions.Item label='下发时间'>
          {data?.updateTs ? new Date(data?.updateTs).toLocaleString() : ''}
          </Descriptions.Item>  
          <Descriptions.Item label='下发DDL语句'>
          {
            (data?.ddl??'').split('\n').map((text, index) => <>
            {index!==0 && <br/>}
            {text}
            </>)
          }
          </Descriptions.Item>
        </Descriptions>
      </Spin>
    </Modal>
  )
}

export default FC