import React from "react"
import { Modal, Spin, Input } from 'antd'

import { dispatch } from '../../../../model'

const FC = (props) => {
  const { visible, modelerData, onCancel } = props
  const [loading, setLoading] = React.useState(false)

  const [ddl, setDDL] = React.useState()

  React.useEffect(() => {
    if (visible && modelerData) {
      getPreviewDDL()
    }
  }, [visible, modelerData])

  const getPreviewDDL = () => {
    setLoading(true)
    dispatch({
      type: 'datamodel.getPreviewTableDDL',
      payload: {
        data: modelerData,
      },
      callback: (data) => {
        setLoading(false)
        setDDL(data)
      },
      error: () => {
        setLoading(false)
      }
    }) 
  }

  const close = () => {
    setDDL()
    onCancel?.()
  }

  return (
    <Modal
      visible={visible}
      footer={null}
      width='90%'
      bodyStyle={{ padding: '15px' }}
      title='预览下发DDL'
      centered destroyOnClose
      onCancel={() => { close() }}
    >
      <Spin spinning={loading}>
        <Input.TextArea value={ddl??''} style={{ height: 'calc(80vh - 70px)', resize: 'none'  }} />
      </Spin>
    </Modal>
  )
}

export default FC