import { useEffect, useState } from 'react';
import { Typography, Table } from 'antd';

const { Title } = Typography;

const VersionCompareTable = (props) => {

  const { data, direction = 'left', columns } = props;
  const [ tableData, setTableData ] = useState([]);
  
  useEffect(() => {
    const newTableData = [];
    let columnValue = [];
    if (direction==='left') {
      columnValue = data?.left?.columnValue||[];
    } else if (direction==='right') {
      columnValue = data?.right?.columnValue||[];
    }

    (columnValue||[]).forEach((attrItem) => {
      let newAttrItem = {};
      (attrItem||[]).forEach((item, index) => {
        newAttrItem[`column${index}`] = item;
      })
      newTableData.push(newAttrItem);
    })

    setTableData(newTableData);
    
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ data ])

  return (
    <div>
      <div className='my-3'>
        <Typography>
          <Title level={5}>数据表结构</Title>
        </Typography>
      </div>
      <Table
        columns={columns||[]}
        dataSource={tableData}
        pagination={false}
      />
    </div>
  );
}

export default VersionCompareTable;