
import { Typography, Tooltip } from 'antd';

const { Text, Paragraph, Title } = Typography;

const VersionCompareHeader = (props) => {

  const { data, direction = 'left' } = props;

  return (
    <Typography>
      <div className='mb-3'>
        <Paragraph>
        <Title level={5}>基本信息</Title>
        </Paragraph>
      </div>
      {
        (data?.heads?.tableHead||[]).map((item, index) => {

          let columnValue = {};
          if (direction==='left' && (data?.left?.tableValue||[]).length>index) {
            columnValue = data?.left?.tableValue[index];
          } else if (direction==='right' && (data?.left?.tableValue||[]).length>index) {
            columnValue = data?.right?.tableValue[index];
          }

          let stateClassName = '';
          if (columnValue?.state==='ADD' || columnValue?.state==='UPDATE') {
            stateClassName = 'add';
          } else if (columnValue?.state === 'DELETE') {
            stateClassName = 'delete';
          }

          return (
            <Paragraph>
              <Tooltip key={index} title={columnValue.value||''}>
                <Text ellipsis={true}>
                {item||''}:&nbsp;<Text className={stateClassName}>{columnValue.value||''}</Text>
                </Text>
              </Tooltip>
            </Paragraph>
          );
        })
      }
    </Typography>
  );
}

export default VersionCompareHeader;
