import React, { useState } from "react";
import { Modal } from "antd";

import { dispatch } from '../../../../model';
import ModelTree from './ModelTree';
import { showMessage, showNotifaction } from '../../../../util';

const RecatalogModal = (props) => {
  
  const { onCancel, visible, ids } = props;
  const [ catalogId, setCatalogId ] = useState('');
  const [ confirmLoading, setConfirmLoading ] = useState(false);

  const onSelect = (value) => {
    setCatalogId(value);
  }

  const onOk = () => {
    if ((catalogId||'') === '') {
      showMessage('warn', '请先选择模型目录');
      return;
    }
    
    setConfirmLoading(true);
    dispatch({
      type: 'datamodel.recatalogDataModel',
      payload: {
        params: {
          easyDataModelCatalogId: catalogId,
          easyDataModelerDataModelIds: ids.join(',')
        },
      },
      callback: message => {
        setConfirmLoading(false);

        if (message) {
          if (message === 'ok') {
            showMessage('success', '变更目录成功')
          } else {
            showMessage('warn', '变更目录失败，所选对象含审批中或变更中模型，不允许变更目录')
          }
        }

        reset();
        onCancel && onCancel(true);
      },
      error: () => {
        setConfirmLoading(false);
      }
    })
  }

  const reset = () => {
    setConfirmLoading(false);
    setCatalogId('');
  }

  return(
    <div>
    {
      visible && <Modal
        title='变更目录详情'
        centered
        visible={ visible }
        width={ 400 }
        confirmLoading={ confirmLoading }
        onCancel={()=>{ 
          reset();
          onCancel && onCancel()
        }}
        onOk={ onOk }
      >
        <ModelTree
          refrence='recatalog'
          onSelect={onSelect} 
        /> 
      </Modal>
    }
    </div>
  )
}

export default RecatalogModal;