import React from 'react';
import { Table, Space, Tooltip, Button, Pagination, Divider } from 'antd';
import { ReconciliationOutlined } from '@ant-design/icons';

import { paginate } from '../../../../util';

const columns = [
  {
    title: '导入名称',
    dataIndex: 'name',
  },
  {
    title: '导入方式',
    dataIndex: 'model',
  },
  {
    title: '开始时间',
    dataIndex: 'startTime',
  },
  {
    title: '结束时间',
    dataIndex: 'endTime'
  },
  {
    title: '状态',
    dataIndex: 'status'
  },
  {
    title: '操作',
    key: 'action',
    render: (text,record) => {
      return (
        <Space size='small'>
          <Tooltip placement='bottom' title={'详情'}>
            <Button icon={<ReconciliationOutlined />} size='small' />
          </Tooltip>
        </Space>
      )
    }
  }
];

const data = [];
for (let i = 0; i < 46; i++) {
  data.push({
    key: i,
    name: `t_szse_transaction${i}`,
    model: 'excel导入',
    startTime: '2020-01-01 00:00:01',
    endTime: '2020-01-01 00:10:01',
    status: '成功'
  });
}

class ImportLog extends React.Component {
  
  constructor() {
    super();
    this.state = { 
      pageNum: 1, 
      pageSize: 10 
    };
  }

  render() {
    const { pageNum, pageSize } = this.state;

    const _data = paginate(data, pageNum, pageSize);

    return (
      <>
        <Divider orientation="left">导入日志</Divider>
        <Table 
          columns={columns} 
          dataSource={_data}
          pagination={false} 
          size='small'
        />
        <Pagination
          className="text-center mt-3"
          showSizeChanger
          showQuickJumper
          onChange={(_pageNum, _pageSize) => {
            this.setState({ pageNum: _pageNum, pageSize: _pageSize || 10 });
          }}
          onShowSizeChange={(_pageNum, _pageSize) => {
            this.setState({ pageNum: _pageNum || 1, pageSize: _pageSize });
          }}
          current={pageNum}
          pageSize={pageSize}
          defaultCurrent={1}
          total={(data||[]).length}
          showTotal={total => `共 ${total} 条`}
        />
      </>
    )
  }
}

export default ImportLog;