import React from 'react';
import { Input, Row, Col, Descriptions } from 'antd';

class ImportExcelCopy extends React.Component {

  constructor() {
    super();
    this.state = {
      inputValue: '',
      translateValues: []
    };
  }

  componentDidUpdate(preProps, preState) {
    const { visible } = this.props;
    if (!visible && visible !== preProps.visible) {
      this.setState({ inputValue: '', translateValues: [] });
    }
  }

  onInputChange = (e) => {
    const { onChange } = this.props;
    this.setState({ inputValue: e.target.value }, () => {
      const _translateValues = e.target.value.replace(/[,,，_ ]/g,'\n').split('\n').filter(value => value!==''&&value!==' ');
      onChange && onChange(_translateValues);
      this.setState({ translateValues: _translateValues });
    });
  }


  render() {

    const { inputValue, translateValues } = this.state;

    const _placeholder = '请在此输入表名、字段中文名，支持以空格、逗号或换行符作为分隔符。如"证券资料表 证券名称 账户代码，证券代码"';

    let _modelName = '', _attrsStr = '';
    if (translateValues.length>0) {
      _modelName= translateValues[0];
    }

    translateValues.forEach((item, index) => {
      if (index === 0) {
        _attrsStr = '';
      } else if (index === 1) {
        _attrsStr = item;
      } else {
        _attrsStr += `,${item}`;
      }
    })

    return (
      <Row gutter={10}>
        <Col span={14}>
          <Input.TextArea 
            value={inputValue||''}
            onChange={this.onInputChange} 
            autoSize={{minRows:4,maxRows:20}} 
            placeholder={_placeholder}
          >
          </Input.TextArea>
        </Col>
        <Col span={10}>
          <Descriptions className='excel-copy-descritpion' column={1} size='small' style={{ maxHeight: 450, overflow: 'auto' }}>
            <Descriptions.Item label='模型名称'>
            { _modelName }
            </Descriptions.Item>
            <Descriptions.Item label='字段名称'>
            { _attrsStr }
            </Descriptions.Item>
          </Descriptions>  
        </Col>
      </Row>
    )
  }
}

export default ImportExcelCopy;