import React from 'react';
import { Button, Upload, Form, Row, Col } from 'antd';
import { DownloadOutlined, UploadOutlined } from '@ant-design/icons';

class ImportExcel extends React.Component {

  constructor() {
    super();
    this.state = {
      fileList: []
    };
  }

  componentDidUpdate(preProps, preState) {
    const { visible } = this.props;
    if (!visible && visible !== preProps.visible) {
      this.setState({ fileList: [] });
    }
  }

  downloadTemplate = () => {
    window.open("/data-govern/docs/DataModel.xlsx");
  }

  normFile = (e) => {  
    const { fileList } = this.state;
    return fileList;
  };

  render() {

    const { onChange } = this.props;
    const { fileList } = this.state;

    const uploadProps = {
      onRemove: file => {
        const index = fileList.indexOf(file);
        const newFileList = fileList.slice();
        newFileList.splice(index, 1);

        this.setState({ fileList: newFileList });
      },
      beforeUpload: file => {
        
        onChange && onChange([file]);
        this.setState({ fileList: [file] });

        return false;
      },
      accept:".xlsx",
      fileList: fileList||[]
    };

    return (
      <Form.Item 
        label='文件上传'
        required={true} 
      >
        <Row>
          <Col span={9}>
            <Form.Item
              name='upload'
              valuePropName="fileList"
              getValueFromEvent={this.normFile}
              noStyle
              rules={[
                {
                  required: true,
                  message: '请选择文件上传',
                },
              ]}
            >
              <Upload {...uploadProps}>
                <Button icon={<UploadOutlined />}>
                  选择文件上传
                </Button>
              </Upload>
            </Form.Item>
          </Col>
          <Col span={6}>
            <Button icon={<DownloadOutlined />} onClick={ this.downloadTemplate }>
            模版下载
            </Button>
          </Col>
        </Row>
        
      </Form.Item>
    )
  }
}

export default ImportExcel;