import { useState } from 'react';
import { Popover, Table } from 'antd';
import { MenuOutlined } from '@ant-design/icons';

const { Column } = Table;

const ColumnSelect = (props) => {
  const { columns, onChange, defaultSelectedKeys } = props;

  const [ selectedKeys, setSelectedKeys ] = useState(defaultSelectedKeys);

  const changeSelect = (selectedRowKeys) => {
    setSelectedKeys(selectedRowKeys);
    onChange && onChange(selectedRowKeys);
  }

  const rowSelection = {
    selectedRowKeys: selectedKeys,
    onChange:changeSelect
  }

  return(
    <div style={{width:230}}>
      <Table
        rowKey="title"
        rowSelection={rowSelection}
        showHeader={true}
        pagination={false}
        size="small"
        scroll={{ y:350 }}
        dataSource={columns}
      >
        <Column title="字段名字" dataIndex="title" key="title" />
      </Table>
    </div>
  )
}

const FilterColumnAction = (props) => {
  return (
    <Popover 
      title="选择显示字段" 
      placement="leftTop" 
      content={
        <ColumnSelect {...props} />
      }>
      <MenuOutlined />
    </Popover>
  );
}

export default FilterColumnAction;