import React, { useState, useContext } from 'react';
import { Modal, Button, Form, Radio } from 'antd';
import { AppContext } from '../../../../App';
import { getDataModelerRole } from '../../../../util';
import { DataModelerRoleAdmin } from '../../../../util/constant';

const exportModes = [
  { name: '导出DDL', key: 'ddl' },
  { name: '下发盘古', key: 'upload' },
  // { name: '导出Erwin', key: 'erwin' },
  // { name: '导出Excel', key: 'excel' },
  // { name: '导出Word', key: 'word' },
  // { name: '导出模型信息', key: 'basicExcel' },
] 

const ExportOtherModal = (props) => {
  const { visible, onCancel } = props;
  const [ modeKey, setModeKey ] = useState('');

  const app = useContext(AppContext);

  const [ form ] = Form.useForm();

  const _exportModes = React.useMemo(() => {
    if (getDataModelerRole(app?.user) !== DataModelerRoleAdmin) {
      return exportModes.filter(item => item.key !== 'upload')
    } 
   
    return exportModes
  }, [app])

  const onModeChange = (e) => {
    setModeKey(e.target?.value);
  }

  const onOk = async() => {
    try {
      await form.validateFields();
      reset();
      onCancel && onCancel(modeKey);

    } catch (errInfo) {
      console.log('Validate Failed:', errInfo);
    }

  }

  const cancel = () => {
    reset();
    onCancel && onCancel();
  }

  const reset = () => {
    form.resetFields();
    setModeKey('');
  }

  const footer = [ 
    <Button
      key="0" 
      onClick={cancel}
    >
    取消
    </Button>,
    <Button
      key="1" 
      type="primary"
      onClick={onOk}
    >
    确定
    </Button>,
  ];

  return (
    <Modal 
      forceRender
      visible={visible}
      title='模型导出'
      width={540}
      onCancel={cancel}
      footer={footer}
    >
      <Form form={form}>
        <Form.Item 
          name='mode'
          label='导出方式'
          rules={[
            {
              required: true,
              message: '请选择导出方式',
            },
          ]}
        >
          <Radio.Group onChange={onModeChange} value={modeKey}>
          {
            _exportModes.map((item, index) => {

              return (
                <Radio 
                  value={item.key}
                  key={index} 
                >
                  {item.name}
                </Radio>
              );
            })
          }
          </Radio.Group>
        </Form.Item>
      </Form>
    </Modal>
  )
}

export default ExportOtherModal;