import React, { useState } from "react";
import { Modal } from "antd";

import ModelTree from './ModelTree';
import { showMessage } from '../../../../util';

const CatalogModal = (props) => {
  
  const { onCancel, visible } = props;
  const [ catalogId, setCatalogId ] = useState('');

  const onSelect = (value) => {
    setCatalogId(value);
  }

  const onOk = () => {
    if ((catalogId||'') === '') {
      showMessage('warn', '请先选择模型目录');
      return;
    }
    
    onCancel && onCancel(catalogId);
  }

  const reset = () => {
    setCatalogId('');
  }

  return(
    <Modal
        title='选择目录'
        visible={ visible }
        width={ 400 }
        onCancel={()=>{ 
          reset();
          onCancel && onCancel()
        }}
        onOk={ onOk }
      >
      {
        visible && <ModelTree
          refrence='recatalog'
          onSelect={onSelect} 
        />
      } 
      </Modal>
  )
}

export default CatalogModal;