import React from 'react';
import { Chart } from '@antv/g2';

class HorizontalBar extends React.Component {

  componentDidMount() {
    const { data, type } = this.props;

    setTimeout(() => {
      const chart = new Chart({
        container: `horizontal-bar${type||''}`,
        autoFit: true,
      });
      
      chart.data(data);
      chart.scale('value', { nice: true });
      chart.coordinate().transpose();
      chart.tooltip({
        showMarkers: false
      });
      chart.interaction('active-region');
      chart.interval().position('name*value');
      chart.render();
    }, 100);
    
  }

  render() {
    const { type } = this.props;

    return (
      <div id={`horizontal-bar${type||''}`} style={{ width: '100%', height: 350 }}></div>
    )
  }
}

export default HorizontalBar;