import React, { useEffect, useState, useContext } from 'react';
import { Modal, Form, Input, Select, Space, Button } from 'antd';

import { AppContext } from '../../../App';
import { dispatch } from '../../../model';
import { AuditProgress, Basic, Process, Template } from './TaskDetail';

const FC = (props) => {
  const { visible, onCancel, task, action } = props;

  const [form] = Form.useForm();
  const [confirmLoading, setConfirmLoading] = useState(false);
  const { user } = useContext(AppContext);

  const handleOk = async (status = '1') => {
    try {
      const values = await form.validateFields();
      
      setConfirmLoading(true);
      dispatch({
        type: 'assetmanage.auditTask',
        payload: {
          params: {
            taskId: task?.id
          },
          data: {
            dealUser: user?.userName??'test',
            processDate: new Date().toLocaleString(),
            status,
            title: action,
            value: values.content
          }
        },
        callback: data => {
          setConfirmLoading(false);
          reset();
          onCancel && onCancel(true);
        },
        error: () => {
          setConfirmLoading(false);
        }
      })
    } catch (errInfo) {

    }
  }

  const reset = () => {
    setConfirmLoading(false);
    form.resetFields();
  }

  return (
    <Modal 
      visible={visible}
      title={`${action}${task?.title}`}
      width={1000}
      confirmLoading={confirmLoading}
      onCancel={() => {
        reset();
        onCancel && onCancel();
      }}
      footer={
        <Space>
          <Button onClick={() => onCancel && onCancel() }>取消</Button>
          <Button type="primary" onClick={() => {handleOk()}} loading={confirmLoading}>确定</Button>
          {
            (action==='审核') && <Button type="danger" onClick={() => {handleOk('-1')}} loading={confirmLoading}>驳回</Button>
          }
        </Space>
      }
    >
      <Form 
        form={form}
      >
        <Form.Item 
          label={`${action}意见`} 
          name="content" 
          rules={[{ required: true, message: `请输入${action}意见` }]}
        >
          <Input.TextArea rows={4} placeholder={`请输入${action}意见`} />
        </Form.Item>
      </Form>

      <AuditProgress task={task} />
      <Basic task={task} />
      <Process task={task} />
      <Template task={task} />
    </Modal>
  );
}

export default FC;