import React from 'react';
import { Row, Col, Typography } from 'antd';

import MetadataInfo from './MetadataInfo';
import './AssetItem.less';

const AssetItem = (props) => {

  const { data } = props;

  return (
    <div className='asset-item'>
    {
      (data.elementsGroup||[]).map((elementGroup, index) => {
        const _type = elementGroup.type||'';

        return (
          <div key={index}>
            <div className='flex' style={{ alignItems: 'center', padding: '15px 0' }}>
              <div style={{ width: 3, height: 14, backgroundColor: '#0069AC', marginRight: 5 }} />
              <span style={{ fontWeight: 'bold', color: '#464646' }}>{_type||''}</span>
            </div>
            <Row>
            {
              elementGroup && elementGroup.elements && elementGroup.elements.map((element, _index) => {
                return (
                  <Col className='mb-3' key={_index} md={8}>
                    <Typography.Paragraph title={ `${element.name||''}: ${element.value||''}` } style={{ color: '#464646' }} ellipsis>
                    { `${element.name||''}: `}
                    { element.name==='资产项'?<MetadataInfo config={false} value={element.value||''} />:`${element.value||''}` }
                    </Typography.Paragraph>
                  </Col>
                );
              })
            }
            </Row>
            <div style={{ width: '100%', height: 2, backgroundColor: '#ededed' }} />
          </div>
        )
      })
    }
    </div>
  );
}

export default AssetItem;