import React, { useEffect, useState } from 'react';
import { Spin, Tooltip, Typography, Dropdown, Menu } from 'antd';

import { dispatch } from '../../../../model';
import { AssetBrowseReference, AssetManageReference, ResourceBrowseReference } from '../../../../util/constant';
import ImportElement from './ImportElement';
import AttributeRelationModal from "./AttributeRelationModal";
import FilterElementModal from './FilterElementModal';
import { showNotifaction } from '../../../../util';
import { MoreSvg } from './AssetSvg';
import Separate from './Separate';
import record from '../Assets/record.png'; 

import './AssetDirectory.less';
import { getTemplateType } from '../../../../util/axios';

const { Paragraph, Text } = Typography;

const AssetDirectory = (props) => {
  const { id, directoryChanged, assetCount, reference = AssetManageReference, onElementsChange, nodeType } = props;
  const [ dir, setDir ] = useState(null);
  const [ loading, setLoading ] = useState(false);
  const [ importElementVisible, setImportElementVisible ] = useState(false);
  const [ attributeRelationModalVisible, setAttributeRelationModalVisible ] = useState(false);
  const [ filterElementVisible, setFilterElementVisible ] = useState(false);
  const [ resourceState, setResourceState ] = useState(null);

  useEffect(() => {

    const storageChange = (e) => {
      if (e.key === 'assetResourceChange') {
        getResourceState();
      }
    }

    window?.addEventListener("storage", storageChange);
  
    return () => {
      window?.removeEventListener("storage", storageChange);
    }
  
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [id])

  useEffect(() => {
    if ((id||'')!=='') {
      getDirectory();
    } else {
      setDir()
    }
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [ id, directoryChanged ])

  const getDirectory = () => {
    let url = 'assetmanage.getDirectoryById';
    if ((reference===AssetBrowseReference|| reference===ResourceBrowseReference) && nodeType==='custom') {
      url = 'assetmanage.getPersonalCustomDirectoryById';
    }

    setLoading(true);
    dispatch({
      type: url,
      payload: { 
        dirId: id
      },
      callback: data => {
        setLoading(false);
        setDir(data);

        if (data.resourceType==='innerSource' || data.resourceType==='outerSource') {
          getResourceState();
        } else {
          setResourceState(null);
        }
      },
      error: () => {
        setLoading(false);
      }
    })
  }

  const getResourceState = () => {
    dispatch({
      type: 'assetmanage.countResourceState',
      payload: { 
        dirId: id
      },
      callback: data => {
        setResourceState(data);
      },
      error: () => {
      }
    })
  }

  const onImportElementBtnClick = () => {
    setImportElementVisible(true);
  }

  const onExportElementBtnClick = () => {
    window.open(`/api/dataassetmanager/elementApi/export?templateType=${getTemplateType()}`);
  }

  const onFilterElementClick = () => {
    setFilterElementVisible(true);
  }

  const onAttributeRelationBtnClick = () => {
    setAttributeRelationModalVisible(true);
  }

  const onImportElementCancel = (visible = false, change = false, tip = '') => {
    setImportElementVisible(visible);

    if (change) {
      onElementsChange && onElementsChange();
    }

    if (tip && tip!== '') {
      showNotifaction('导入提示', tip, 5);
    }
  }

  const onFilterElementModalCancel = () => {
    setFilterElementVisible(false);
  }

  const onAttributeRelationModalCancel = () => {
    setAttributeRelationModalVisible(false);
  }

  const elementManageMenu = (
    <Menu>
      <Menu.Item>
        <div className='text-center' onClick={onImportElementBtnClick}>
          导入资产目录属性
        </div>
      </Menu.Item>
      <Menu.Item>
        <div className='text-center' onClick={onExportElementBtnClick}>
          导出资产目录属性
        </div>
      </Menu.Item>
      <Menu.Item>
        <div className='text-center' onClick={onFilterElementClick}>
          资产目录浏览管理
        </div>
      </Menu.Item>
      <Menu.Item>
        <div className='text-center' onClick={onAttributeRelationBtnClick}>
          资产目录属性关联
        </div>
      </Menu.Item>
    </Menu>
  );

  return (
    <Spin spinning={loading}>
      <div
        className='flex p-common asset-directory'
        style={{
          alignItems: 'center',
          justifyContent: 'space-between',
          color: 'rgba(0, 0, 0, 0.85)',
          borderBottom: '1px solid #f0f0f0',
        }}
      >
        <div style={{ flex: 1, overflow: 'hidden'}}>
          <div>
            <div className='mb-common flex'>
              <Paragraph style={{ flex: 1, overflow: 'hidden' }}>
                <Tooltip title={dir?.name||''}>
                  <Text className='title-color'  ellipsis={true}>
                    名称：
                    <Text className='text-color'>{dir?.name||''}</Text>
                  </Text>
                </Tooltip>
              </Paragraph>
              <Separate width={10} background='#fff' />
              <Paragraph style={{ flex: 1, overflow: 'hidden' }}> 
                <Tooltip title={dir?.code||''}>
                  <Text className='title-color'  ellipsis={true}>
                    编号：
                    <Text className='text-color'>{dir?.code||''}</Text>
                  </Text>
                </Tooltip>
              </Paragraph>
            </div>
            <div className={(reference===AssetManageReference)?'mb-common':''}>
              <Paragraph>
                <Tooltip title={dir?.desc||''}>
                  <Text className='title-color' ellipsis={true}>
                    描述：
                    <Text className='text-color'>{dir?.desc||''}</Text>
                  </Text>
                </Tooltip>
              </Paragraph>
            </div>
            {
              (reference===AssetManageReference) && <div className='flex'>
                <Paragraph style={{ flex: 1, overflow: 'hidden' }}>
                  <Tooltip title={dir?.remarks||''}>
                    <Text className='title-color' ellipsis={true}>
                      备注：
                      <Text className='text-color'>{dir?.remarks||''}</Text>
                    </Text>
                  </Tooltip>
                </Paragraph>
                <Separate width={10} background='#fff' />
                {/* {
                  resourceState && <React.Fragment>
                    <Paragraph style={{ flex: 1, overflow: 'hidden' }}>
                      <Tooltip title={resourceState?.relatedAsset}>
                        <Text className='title-color' ellipsis={true}>
                          资产化数量：
                          <Text className='text-color'>{resourceState?.relatedAsset}</Text>
                        </Text>
                      </Tooltip>
                    </Paragraph>
                    <Separate width={10} background='#fff' />
                    <Paragraph style={{ flex: 1, overflow: 'hidden' }}>
                      <Tooltip title={resourceState?.notRelatedAsset}>
                        <Text className='title-color' ellipsis={true}>
                          非资产数量：
                          <Text className='text-color'>{resourceState?.notRelatedAsset}</Text>
                        </Text>
                      </Tooltip>
                    </Paragraph>
                    <Separate width={10} background='#fff' />
                    <Paragraph style={{ flex: 1, overflow: 'hidden' }}>
                      <Tooltip title={resourceState?.uncombed}>
                        <Text className='title-color' ellipsis={true}>
                          未梳理数量：
                          <Text className='text-color'>{resourceState?.uncombed}</Text>
                        </Text>
                      </Tooltip>
                    </Paragraph>
                  </React.Fragment>
                } */}
              </div>
            }
          </div>
        </div>
        <div 
          className='flex' 
          style={{
            width: 200,
            alignItems: 'center',
            justifyContent: 'center'
          }}
        >
          <img src={record} style={{ width: 53, height: 53 }} alt="" />
          <div
            className='flex ml-2'
            style={{
              flexDirection: 'column',
              alignItems: 'center',
              justifyContent: 'center'
            }}
          >
            <div className='text-color'>记录数</div>
            <div className='title-color' style={{ fontSize: 25, fontWeight: 'bold' }}>{assetCount}</div>
          </div>
        </div>
        
        {/* {
          (reference===AssetManageReference) && <Dropdown overlay={elementManageMenu} placement="bottomCenter">
            <div
              className='flex more-container'
              style={{
                flexDirection: 'column',
                alignItems: 'center',
                justifyContent: 'center',
                marginBottom: 42,
              }}
            >
              <MoreSvg style={{ width: 20, height: 20, marginBottom: 5 }} />
              <span style={{ fontSize: 10 }}>更多</span>
            </div>
          </Dropdown>
        } */}
      
      </div>
      
      <ImportElement 
        visible={importElementVisible}
        onCancel={onImportElementCancel}
      />

      <FilterElementModal
        visible={ filterElementVisible }
        onCancel={ onFilterElementModalCancel}
      />

      <AttributeRelationModal
        visible={ attributeRelationModalVisible }
        onCancel={ onAttributeRelationModalCancel }
      />
    </Spin>
  );
}

export default AssetDirectory;