import React from 'react';
import * as echarts from 'echarts';

//https://echarts.apache.org/examples/zh/editor.html?c=treemap-show-parent&lang=js
class Thermodynamic extends React.Component {

  componentDidMount() {
    const { data, onClick } = this.props;

    if (data && data.length>0 && (data[0].children||[]).length>0) {
      this.graph = init(this)(this.elem, data, onClick);
    }
  }

  componentDidUpdate(prevProps, prevState) {
    const { data, onClick, resize } = this.props;

    if (data !== prevProps.data) {
      this.graph?.dispose();
      this.graph = init(this)(this.elem, data, onClick);
    } else if (resize !== prevProps.resize) {
      this.graph?.resize();
    }
  }

  elem = undefined;
  graph = undefined;

  render() {
    return (
      <div ref={ref => this.elem = ref} style={{ position: 'relative', width: '100%', height: '100%' }}>
      </div>
    );
  }
}

export default Thermodynamic;

const init = (ctx) => function (container, data, onClick) {
  var myChart = echarts.init(container);

  function getLevelOption() {
    return [
      {
        itemStyle: {
          borderColor: ((data||[]).length>0)&&(data[0].dataAssetAndSubDirCount===0||(data[0].children||[]).reduce((preVal, item) => item?.dataAssetAndSubDirCount + preVal, 0)===0) ? '#97aeed' : '#777',
          borderWidth: 0,
          gapWidth: 1
        },
        upperLabel: {
          show: false
        }
      },
      {
        itemStyle: {
          borderColor: '#555',
          borderWidth: 5,
          gapWidth: 1
        },
        emphasis: {
          itemStyle: {
            borderColor: '#ddd'
          }
        }
      },
      {
        colorSaturation: [0.35, 0.5],
        itemStyle: {
          borderWidth: 5,
          gapWidth: 1,
          borderColorSaturation: 0.6
        }
      }
    ];
  }

  var option = {
    title: {
      text: ((data||[]).length>0) ? `${data[0]?.text||''} (${data[0]?.dataAssetAndSubDirCount})` : '',
      left: 'center',
      bottom: 10,
      textStyle: {
        fontSize: 16
      }
    },
    tooltip: {
      formatter: function (info) {
        var treePathInfo = info.treePathInfo;
        var treePath = [];
        for (var i = 1; i < treePathInfo.length; i++) {
          treePath.push(treePathInfo[i].name);
        }
        return [
          '<div class="tooltip-title">' +
            echarts.format.encodeHTML(treePath.join('/')) +
            '</div>',
        ].join('');
      }
    },
    series: [
      {
        name: ((data||[]).length>0) ? `${data[0]?.text||''} (${data[0]?.dataAssetAndSubDirCount})` : '',
        type: 'treemap',
        height: '85%',
        visibleMin: 1,
        childrenVisibleMin: 1,
        label: {
          show: true,
          formatter: '{b}'
        },
        upperLabel: {
          show: true,
          height: 30,
          color: '#fff',
        },
        itemStyle: {
          borderColor: '#555'
        },
        breadcrumb: {
          show: false,
        },
        levels: getLevelOption(),
        data: ((data||[]).length>0) ? (data[0].children||[]) : [],
      }
    ]
  };

  myChart.setOption(option);

  myChart.on('click', function (params) {
    const { data } = params;

    if (onClick && data && data.nodeId) {
      onClick(data.nodeId);
    }
  });

  if (typeof window !== 'undefined') {
    window.onresize = () => {
      myChart?.resize();
    };
  }

  return myChart;
}