
import { PostJSON, Post, GetJSON } from "../util/axios"

export function sessionInfo(payload) {
  return PostJSON("/auth/sessionInfo", payload)
}
export function signin(payload) {
  return Post("/auth/signin", payload)
}
export function signout() {
  return Post("/auth/signout")
}

export function queryRoles() {
  return GetJSON("/authservice/personal/roles");
}

export function queryUserSystem(payload) {
  return GetJSON("/authservice/personal/grantedScopes", payload);
}

export function getDomains() {
  return GetJSON("/authservice/domains");
}

export function userGroups() {
  return GetJSON("/authservice/userGroups");
}

export function getGroupUsers(payload) {
  return GetJSON(`/authservice/userGroups/${payload.id}/users`)
}

export function getMcclUsers() {
  return PostJSON("/auth/peopleCenter/listMcclUser")
}

export function getMcclDepartments() {
  return PostJSON("/auth/peopleCenter/getOrganMcclList")
}