import request from "../util/request";
import config from "../commons";
import qs from "qs";

const {
  api: { tagger },
} = config

export function loadTagCatalogTree(data, successdo, errordo) {
  request(
    { url: `${tagger}/tag/loadTagCatalogTree`, method: "get", data: data },
    successdo,
    errordo
  )
}

export function getSupportTagForm(data, successdo, errordo) {
  request(
    { url: `${tagger}/tag/getSupportTagForm`, method: "get", data: data },
    successdo,
    errordo
  )
}

export function saveTag(isDefault, data, successdo, errordo) {
  request(
    { url: `${tagger}/tag/saveTag?isDefault=${isDefault}`, method: "post", data: data },
    successdo,
    errordo
  )
}

export function deleteTag(id, successdo, errordo) {
  request(
    { url: `${tagger}/tag/deleteTag?id=${id}`, method: "delete", data: null },
    successdo,
    errordo
  )
}

export function getTagByKeywordAndCreator(data, successdo, errordo) {
  request(
    { url: `${tagger}/tag/getTagByKeywordAndCreator`, method: "get", data: data },
    successdo,
    errordo
  )
}

export function getTagDataById(data, successdo, errordo) {
  request(
    { url: `${tagger}/tag/getTagDataById`, method: "get", data: data },
    successdo,
    errordo
  )
}

export function batchAddTagResource(data, successdo, errordo) {
  request(
    { url: `${tagger}/tagResource/batchAddTagResource`, method: "post", data: qs.stringify(data) },
    successdo,
    errordo
  )
}

export function newbatchAddTagResource(data, successdo, errordo) {
  request(
    { url: `${tagger}/tagResource/batchAddTagResourceMultiTags`, method: "post", data: qs.stringify(data) },
    successdo,
    errordo
  )
}

export function deleteTagResource(data, successdo, errordo) {
  request(
    { url: `${tagger}/tagResource/deleteTagResource?esIds=${data}`, method: "delete", data: null },
    successdo,
    errordo
  )
}

export function getResourceTagIn(data, successdo, errordo) {
  request(
    { url: `${tagger}/tagResource/getResourceTagIn`, method: "post", data: qs.stringify(data) },
    successdo,
    errordo
  )
}

//通过条件分页获取挂靠资源
export function getTagResourceDataPage(data, successdo, errordo) {
  request(
    { url: `${tagger}/tagResource/getTagResourceDataPage`, method: "get", data: data },
    successdo,
    errordo
  )
}

export function getSupportCatalogForm(data, successdo, errordo) {
  request(
    { url: `${tagger}/tag/getSupportCatalogForm`, method: "get", data: data },
    successdo,
    errordo
  )
}

export function saveTagCatalog(data, successdo, errordo) {
  request(
    { url: `${tagger}/tag/saveTagCatalog`, method: "post", data: data },
    successdo,
    errordo
  )
}

export function getCatalogById(data, successdo, errordo) {
  request(
    { url: `${tagger}/tag/getCatalogById`, method: "get", data: data },
    successdo,
    errordo
  )
}

export function deleteCatalog(id, successdo, errordo) {
  request(
    { url: `${tagger}/tag/deleteCatalog?id=${id}`, method: "delete", data: null },
    successdo,
    errordo
  )
}