import * as userService from '../service/user';
import * as metadataService from '../service/metadata';
import * as datamodelerService from '../service/datamodeler';
import { call } from 'redux-saga/effects';

export function* getAllSystemAndDatabase() {
  const roleData = yield call(userService.queryRoles);

  let isAdminMode = false;
  roleData && roleData.roleData && roleData.roleData.forEach((item) => {
    if(item.roleId === 2) {
      isAdminMode=true;
    }
  })
  
  const systems = yield call(userService.queryUserSystem, { isAdminMode });

  let dbData = [];
  if (systems.length) {
    const _system = systems[0].scopeId;
    dbData = yield call(metadataService.queryDatabase, { sysCodeList: _system });
  }
  
  return { systems, dbs: [ { value: '', name: '所有数据源' } , ...(dbData||[])] };
  
}

export function* getAllSystemDatabase(payload) {
  const dbData = yield call(metadataService.queryDatabase, payload);

  return [ { value: '', name: '所有数据源' } , ...(dbData||[])];
}

export function* getAllScheme(payload) {
  let value = payload.db.split(',');
  const schemaData = yield call(metadataService.querySchemeByParentId, {parentId:value[0]});

  return [ { value: '', name: '所有Schema' } , ...(schemaData||[])]
}

export function* getAllDataTable(payload) {
  return yield call(metadataService.queryAllDataTable, payload);
}

export function* getAllFileds(payload) {
  return yield call(metadataService.queryAllFields, payload);
}

export function* loadDataModelCatalog() {
  return yield call(datamodelerService.loadDataModelCatalog);
}

export function* refreshDataModelCatalog() {
  return yield call(datamodelerService.refreshDataModelCatalog);
}

export function* upDownModelCatalog(payload) {
  return yield call(datamodelerService.upDownModelCatalog, payload);
}

export function* loadDataModelStateCatalog() {
  return yield call(datamodelerService.loadDataModelStateCatalog);
}

export function* saveDataModelCatalog(payload) {
  return yield call(datamodelerService.saveDataModelCatalog, payload);
}

export function* deleteDataModelCatalog(payload) {
  return yield call(datamodelerService.deleteDataModelCatalog, payload);
}

export function* bindCatalogDataModel(payload) {
  return yield call(datamodelerService.bindCatalogDataModel, payload);
}

export function* getCurrentDataModelCatalog(payload) {
  return yield call(datamodelerService.getCurrentDataModelCatalog, payload);
}

export function* getCurrentDataModelStateCatalog(payload) {
  return yield call(datamodelerService.getCurrentDataModelStateCatalog, payload);
}

export function* nextState(payload) {
  return yield call(datamodelerService.nextState, payload);
}

export function* recatalogDataModel(payload) {
  return yield call(datamodelerService.recatalogDataModel, payload);
}

export function* modelCopy(payload) {
  return yield call(datamodelerService.modelCopy, payload);
}

export function* getSupportedPartitionTypes(payload) {
  return yield call(datamodelerService.getSupportedPartitionTypes, payload);
}

export function* savePartitionType(payload) {
  return yield call(datamodelerService.savePartitionType, payload);
}

export function* deletePartitionType(payload) {
  return yield call(datamodelerService.deletePartitionType, payload);
}

export function* getSupportedIndextypes() {
  return yield call(datamodelerService.getSupportedIndextypes);
}

export function* extractExcelContent(payload) {
  return yield call(datamodelerService.extractExcelContent, payload);
}

export function* getAllConstraintsAndTemplates() {
  const constraints = yield call(datamodelerService.constraints);
  const templates = yield call(datamodelerService.templates);

  return { constraints, templates }; 
}

export function* getAllConstraints() {
  return yield call(datamodelerService.constraints);
}

export function* getAllTemplates() {
  return yield call(datamodelerService.templates);
}

export function* getTemplate(payload) {
  return yield call(datamodelerService.getTemplate, payload);
}

export function* saveTemplate(payload) {
  return yield call(datamodelerService.saveTemplate, payload);
}

export function* deleteTemplate(payload) {
  return yield call(datamodelerService.deleteTemplate, payload);
}

//获取初稿
export function* getDraft(payload) {
  return yield call(datamodelerService.draft, payload);
}

export function* getDraftUsingDDL(payload) {
  return yield call(datamodelerService.draftUsingDDL, payload);
}

export function* getDraftUsingMetadataId(payload) {
  return yield call(datamodelerService.draftUsingMetadataId, payload);
}

export function* getConsult(payload) {
  return yield call(datamodelerService.consult, payload);
}

export function* translatePhase(payload) {
  return yield call(datamodelerService.translatePhase, payload);
}

export function* getSupportedDatatypes() {
  return yield call(datamodelerService.getSupportedDatatypes);
}

export function* suggest(payload) {
  return yield call(datamodelerService.suggest, payload);
}

export function* preSaveDataModel(payload) {
  return yield call(datamodelerService.preSaveDataModel, payload);
}

export function* saveDataModel(payload) {
  return yield call(datamodelerService.saveDataModel, payload);
}

export function* deleteDataModel(payload) {
  return yield call(datamodelerService.deleteDataModel, payload);
}

export function* deleteDataModels(payload) {
  return yield call(datamodelerService.deleteDataModels, payload);
}

export function* getDataModel(payload) {
  return yield call(datamodelerService.getDataModel, payload);
}

export function* getDataModelWithRecommendedDefinitionAndTermDiscovery(payload) {
  return yield call(datamodelerService.getDataModelWithRecommendedDefinitionAndTermDiscovery, payload);
}

export function* checkOutDataModel(payload) {
  return yield call(datamodelerService.checkOutDataModel, payload);
}

export function* getCheckoutDataModel(payload) {
  return yield call(datamodelerService.getCheckoutDataModel, payload);
}

export function* getRangeList(payload) {
  return yield call(datamodelerService.getRangeList, payload);
}

export function* getDataModelLocation(payload) {
  return yield call(datamodelerService.getDataModelLocation, payload);
}

export function* ddlGenerators() {
  return yield call(datamodelerService.ddlGenerators);
}

export function* exportDDLString(payload) {
  return yield call(datamodelerService.exportDDLString, payload);
}

export function* exportERWinString(payload) {
  return yield call(datamodelerService.exportERWinString, payload);
}

export function* uploadWordTemplate(payload) {
  return yield call(datamodelerService.uploadWordTemplate, payload);
}

export function* importWordGenerateModel(payload) {
  return yield call(datamodelerService.importWordGenerateModel, payload);
}

export function* importWordLogs(payload) {
  return yield call(datamodelerService.importWordLogs, payload);
}

export function* importWordGenerateModelDraft(payload) {
  return yield call(datamodelerService.importWordGenerateModelDraft, payload);
}

export function* uploadDDL(payload) {
  return yield call(datamodelerService.uploadDDL, payload);
}

export function* heartbeat() {
  return yield call(datamodelerService.heartbeat);
}

export function* downloadExportTableDDLListZip(payload) {
  return yield call(datamodelerService.downloadExportTableDDLListZip, payload);
}

export function* exportTableDDLAbstractList(payload) {
  return yield call(datamodelerService.exportTableDDLAbstractList, payload);
}

export function* getExportTableDDL(payload) {
  return yield call(datamodelerService.getExportTableDDL, payload);
}

export function* getPreviewTableDDL(payload) {
  return yield call(datamodelerService.getPreviewTableDDL, payload);
}

export function* validateDataModel(payload) {
  return yield call(datamodelerService.validateDataModel, payload);
}

export function* autocomplete(payload) {
  return yield call(datamodelerService.autocomplete, payload);
}

export function* recommandEnglishWords(payload) {
  return yield call(datamodelerService.recommandEnglishWords, payload);
}

export function* startFlow(payload) {
  return yield call(datamodelerService.startFlow, payload);
}

export function* getDatasourcesByEnv(payload) {
  return yield call(datamodelerService.getDatasourcesByEnv, payload);
}

export function* getSchemasByDatasourceId(payload) {
  return yield call(datamodelerService.getSchemasByDatasourceId, payload);
}

export function* getParent(payload) {
  return yield call(datamodelerService.getParent, payload);
}

export function* autoCreateTable(payload) {
  return yield call(datamodelerService.autoCreateTable, payload);
}

export function* searchModel(payload) {
  return yield call(datamodelerService.searchModel, payload);
}

export function* getVersions(payload) {
  return yield call(datamodelerService.getVersions, payload);
}

export function* compare(payload) {
  return yield call(datamodelerService.compare, payload);
}

export function* getDataModelByVersionId(payload) {
  return yield call(datamodelerService.getDataModelByVersionId, payload);
}

export function* getDataModelDigest(payload) {
  return yield call(datamodelerService.getDataModelDigest, payload);
}

export function* isSetRootDomainId() {
  return yield call(datamodelerService.isSetRootDomainId);
}

export function* setRootDomainId(payload) {
  return yield call(datamodelerService.setRootDomainId, payload);
} 

export function* getMaintenanceRecords(payload) {
  return yield call(datamodelerService.getMaintenanceRecords, payload);
}

export function* requirementList(payload) {
  return yield call(datamodelerService.requirementList, payload);
}

export function* getBindingDataList(payload) {
  return yield call(datamodelerService.getBindingDataList, payload);
}

export function* requirementBind(payload) {
  return yield call(datamodelerService.requirementBind, payload);
}

export function* requirementUnbind(payload) {
  return yield call(datamodelerService.requirementUnbind, payload);
}

export function* getRuleTemplateList() {
  return yield call(datamodelerService.getRuleTemplateList);
}

export function* addRuleTemplate(payload) {
  return yield call(datamodelerService.addRuleTemplate, payload);
}

export function* updateRuleTemplate(payload) {
  return yield call(datamodelerService.updateRuleTemplate, payload);
}

export function* deletesRuleTemplate(payload) {
  return yield call(datamodelerService.deletesRuleTemplate, payload);
}

export function* deleteRuleTemplate(payload) {
  return yield call(datamodelerService.deleteRuleTemplate, payload);
}

export function* getRuleTemplateDetail(payload) {
  return yield call(datamodelerService.getRuleTemplateDetail, payload);
}

export function* getRuleTemplateCheckTypes() {
  return yield call(datamodelerService.getRuleTemplateCheckTypes);
}

export function* getRuleTemplateAllCheckPropertyTypes() {
  return yield call(datamodelerService.getRuleTemplateAllCheckPropertyTypes);
}

export function* getRuleTemplateAllVerifyExpressionTypes() {
  return yield call(datamodelerService.getRuleTemplateAllVerifyExpressionTypes);
}

export function* getRuleTemplateAllVertifyExpressions() {
  return yield call(datamodelerService.getRuleTemplateAllVertifyExpressions);
}

/* rule catalog */
export function* addRuleCatalog(payload) {
  return yield call(datamodelerService.addRuleCatalog, payload)
}

export function* updateRuleCatalog(payload) {
  return yield call(datamodelerService.updateRuleCatalog, payload)
}

export function* upRuleCatalog(payload) {
  return yield call(datamodelerService.upRuleCatalog, payload)
}

export function* downRuleCatalog(payload) {
  return yield call(datamodelerService.downRuleCatalog, payload)
}

export function* deleteRuleCatalog(payload) {
  return yield call(datamodelerService.deleteRuleCatalog, payload)
}

export function* getRuleCatalogList() {
  return yield call(datamodelerService.getRuleCatalogList)
}

export function* getRuleCatalogEnableList() {
  return yield call(datamodelerService.getRuleCatalogEnableList)
}

export function* getRuleCatalogVersionList(payload) {
  return yield call(datamodelerService.getRuleCatalogVersionList, payload)
}

export function* compareRuleCatalogVersion(payload) {
  return yield call(datamodelerService.compareRuleCatalogVersion, payload)
}

export function* getRuleCatalogStatus() {
  return yield call(datamodelerService.getRuleCatalogStatus)
}

/* rule */
export function* addRule(payload) {
  return yield call(datamodelerService.addRule, payload)
}

export function* updateRule(payload) {
  return yield call(datamodelerService.updateRule, payload)
}

export function* deleteRules(payload) {
  return yield call(datamodelerService.deleteRules, payload)
}

export function* getRuleList(payload) {
  return yield call(datamodelerService.getRuleList, payload)
}

export function* getRuleAlertTypes() {
  return yield call(datamodelerService.getRuleAlertTypes)
}

export function* getRuleStatus() {
  return yield call(datamodelerService.getRuleStatus)
}

export function* addComment(payload) {
  return yield call(datamodelerService.addComment, payload)
}

export function* deleteComment(payload) {
  return yield call(datamodelerService.deleteComment, payload)
}

export function* getComments(payload) {
  return yield call(datamodelerService.getComments, payload)
}

export function* uploadCommentFile(payload) {
  return yield call(datamodelerService.uploadCommentFile, payload)
}

export function* deleteCommentFile(payload) {
  return yield call(datamodelerService.deleteCommentFile, payload)
}

export function* getSearchProperties() {
  return yield call(datamodelerService.getSearchProperties)
}

export function* searchModelBySearchProperties(payload) {
  return yield call(datamodelerService.searchModelBySearchProperties, payload)
}

//zcx hive
export function* getDbTypes() {
  return yield call(datamodelerService.getDbTypes)
}

//zcx hive
export function* getHiveStoredTypes() {
  return yield call(datamodelerService.getHiveStoredTypes)
}

export function* conceptualModelCreateDataModel(payload) {
  return yield call(datamodelerService.conceptualModelCreateDataModel, payload)
}

export function* getUploadDDLResultDetails(payload) {
  return yield call(datamodelerService.getUploadDDLResultDetails, payload)
}