import React, { Component } from "react";
import { Form, Input, Button } from 'antd';
import { connect } from 'react-redux';
import CryptoJS from "crypto-js";
import { UserOutlined, LockOutlined } from "@ant-design/icons";

import { Open, Assert, ContextPath, showMessage } from '../../util';
import { dispatchLatest } from '../../model';
import loginBG from "../../assets/login_bg.png";

class Signin extends Component {
  
  onFinish = (values) => { 
    const { history, session } = this.props; 
    const { referer } = session||{};

    const username = values['username']||'';
    const password = values['password']||'';        

    dispatchLatest({ 
      type: 'user.signin', 
      payload: { params: { username: username, password: CryptoJS.SHA1(password).toString(CryptoJS.enc.Hex) }},
      callback: sess => {
        if (sess && sess === "expire") {
          Open("/license", {target: "_self"});
          return;
        }
        Assert(sess === "ok", "用户名或密码不正确");
        showMessage('success', '登录成功');
        history.push(referer || `${ContextPath}/home`); 
      }
    });
  }

  render() {
    return (
      <>
        <img className="position-absolute" src={loginBG} style={{ objectFit: 'cover', top: 0, left: 0, right: 0 ,bottom: 0, width: '100%', height:'100%' }} alt="" />
        <div className="position-absolute" style={{ top: '50%', right: '10%', backgroundColor: '#fff', width: 350, transform: 'translateY(-50%)'}}>
          <div style={{ padding: '30px' }}>
            <div style={{ fontSize: 25, fontWeight: 800, color: '#159be9' }}>欢迎，</div>
            <div style={{ fontSize: 15, fontWeight: 500, color: '#159be9', marginBottom: 30 }}>深圳证劵交易所数据治理系统</div>
            <Form onFinish={this.onFinish} className="login-form">
              <Form.Item
                name="username"
                rules={[
                  {
                    required: true,
                    message: "请输入您的用户名!"
                  }
                ]}
              >
                <Input 
                  placeholder="用户名" 
                  prefix={<UserOutlined />} 
                />
              </Form.Item>
              <Form.Item
                name="password"
                rules={[
                  {
                    required: true,
                    message: "请输入您的密码!"
                  }
                ]}
              >
                <Input
                  type="password"
                  placeholder="密码"
                  prefix={<LockOutlined />}
                />
              </Form.Item>
              <Form.Item>
                <Button htmlType="submit" style={{ width: '100%', backgroundColor: '#159BE9', color: '#fff' }}>
                  登录
                </Button>
              </Form.Item>
            </Form>
          </div>
          <div style={{ height: '30px', lineHeight: '30px', backgroundColor: '#f4f4f4', textAlign: 'center', color: '#333', fontSize: 12, fontWeight: 400 }}>技术支持：广州元曜软件有限公司</div>
        </div>
        <div className="position-absolute" style={{ bottom: 10, textAlign: 'center', color: '#fff', fontSize: 12, fontWeight: 400, left: '50%', transform: 'translateX(-50%)' }}>版权所有：深圳证劵交易所</div>
      </>
    );
  }
}

export default connect(
  state => {
    return { session: state.sessionState }
  }
)(Signin);
