import React, { Component } from "react";
import { Route, Switch } from "react-router-dom";
import { connect } from 'react-redux';

import { GetSession } from "../../util";
import { ManageLayout } from "../../layout";

import DatasourceManage from './DatasourceManage';
import Map from './Map';
import Model from './Model';
import ModelConfig from './ModelConfig';
import AssetManage from './AssetManage';
import AssetResourceBrowse from './AssetResourceBrowse';
import AssetBrowse from './AssetBrowse';
import AssetRecycle from './AssetRecycle';
import AssetTask from './AssetTask';
import Asset1104Manage from "./Asset1104Manage";
import AssetDraft from "./AssetDraft";
class Manage extends Component {

  render() {
    const { match } = this.props
    const { session } = this.props;

    return (
      <React.Fragment>
        <ManageLayout
          {...this.props}
          content={
            session && session.userId ? (
              <Switch>
                <Route path={`${match.path}/datasource-manage`} component={DatasourceManage} />
                <Route path={`${match.path}/data-model`} component={Model} />
                <Route path={`${match.path}/model-config`} component={ModelConfig} />
                <Route path={`${match.path}/asset-map`} component={Map} />
                <Route path={`${match.path}/asset-manage`} component={AssetManage} />
                <Route path={`${match.path}/asset-resource-browse`} component={AssetResourceBrowse} />
                <Route path={`${match.path}/asset-browse`} component={AssetBrowse} />
                <Route path={`${match.path}/asset-recycle`} component={AssetRecycle} />
                <Route path={`${match.path}/asset-task`} component={AssetTask} />
                <Route path={`${match.path}/1104-asset`} component={Asset1104Manage} />
                <Route path={`${match.path}/asset-draft`} component={AssetDraft} />
                
              </Switch>
            ) : (
              <GetSession {...this.props} />
            )
          }
        />
      </React.Fragment>
    )
  }
}

export default connect(
  state => {
    return {session: state.sessionState}
  }
)(Manage);