import React, { useEffect, useState } from 'react';
import { Button, Tag, Modal } from 'antd';
import { PlusOutlined } from '@ant-design/icons';

import AddTagModal from './Component/AddNewTagModal';
import { dispatch } from '../../../model';

const TagColumn = (props) => {
  const { id, type = 'dataAsset', creator = '', styleType = 'simple', onAssetTag } = props;

  console.log('creator',creator)

  const [ ownTags, setOwnTags ] = useState([]);
  const [ addTagModalVisible, setAddTagModalVisible ] = useState(false);
  const [modal, contextHolder] = Modal.useModal();

  useEffect(() => {

    if ((id||'') !== '') {
      getTags();
    } else {
      setOwnTags([]);
    }
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [id])

  useEffect(() => {

    window?.addEventListener("storage", tagEventChange);
  
    return () => {
      window?.removeEventListener("storage", tagEventChange);
    }
  
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [])

  const tagEventChange = (e) => {
    if (e.key === 'tagChange' && (id||'') !== '') {
      getTags();
    }
  }

  const getTags = () => {
    dispatch({
      type: 'tag.getResourceTagIn',
      payload: {
        params: {
          resourceIds: id,
          type,
          creator,
          includeAll: true
        }
      },
      callback: data => {
        if (data) {
          setOwnTags(data[id]||[]);
        }
      }
    })
  }

  const onAddBtnClick = () => {
    setAddTagModalVisible(true);
  }

  const onAddTagModalCancel = (refresh=false) => {
    setAddTagModalVisible(false);
    refresh && getTags();
  }

  const onAssetTagCancel = (keyword) => {
    setAddTagModalVisible(false);
    onAssetTag && onAssetTag(keyword);
  }

  const handleClose = (index) => {
    const _tag = ownTags[index];

    modal.confirm({
      title: '提示!',
      content: '您确定要删除该标签吗?',
      onOk: () => {
        dispatch({
          type: 'tag.deleteTagResource',
          payload: {
            esIds: _tag.esId
          },
          callback: () => {
            getTags();
          }
        })
      }
    });

  }

  // let tagsContent = '';
  // (ownTags||[]).forEach((item, index) => {
  //   if (index === 0) {
  //     tagsContent = (item.name||'');
  //   } else {
  //     tagsContent += ',' + (item.name||'');
  //   }
  // })

  return (
    <React.Fragment>
    {
      (styleType==='simple') && <div>
      {
        (ownTags||[]).map((item, index) => {
          return (
            <Tag 
              key={index} 
              style={{ marginBottom: 5 }}
              color={item.type==='public'?'#2db7f5':'volcano'}
            >
            { item.name||'' }
            </Tag>
          );
        })
      }
      </div>
    }
    {
      (styleType==='complex') && <div> 
        <div>
        {
          (ownTags||[]).map((item, index) => {
            return (
              <Tag 
                key={index} 
                closable
                onClose={e => {
                  e.preventDefault();
                  handleClose(index);
                }}
                style={{ marginBottom: 5 }}
                color={item.type==='public'?'#2db7f5':'volcano'}
              >
              { item.name||'' }
              </Tag>
            );
          })
        }
        </div>
        <div>
        <Button 
          size='small' 
          type='text'
          icon={<PlusOutlined />}
          onClick={onAddBtnClick}
          style={{zIndex:100}}
        >
          新增标签
        </Button>
        </div>
      </div>
    }
    <AddTagModal 
      visible={addTagModalVisible}  
      id={id}
      type={type}
      creator={creator}
      onCancel={onAddTagModalCancel}
      onAssetTag={onAssetTagCancel}  
    />
    {contextHolder}  
    </React.Fragment>
  );
}

export default TagColumn;