import React from 'react'
import { Button, Modal, Spin, Form, Input, Select } from 'antd'

import { dispatch } from '../../../../model'

const FC = (props) => {
  const { visible, item, onCancel } = props
  const [waiting, setWaiting] = React.useState(false)
  const basicRef = React.useRef()

  const close = (refresh = false) => {
    setWaiting(false)
    onCancel?.(refresh)
  }

  const save = async() => {
    try {
      const rows = await basicRef.current?.validate()
      setWaiting(true)
      dispatch({
        type: 'datamodel.updateRule',
        payload: {
          params: {id: item?.id, ...rows},
        },
        callback: data => {
          close(true)
        },
        error: () => {
          setWaiting(false)
        }
      })   
    } catch (e) {
      
    }
  }

  const footer = React.useMemo(() => {
    return [
      <Button key='cancel'
        onClick={() => close()}
      >取消</Button>,
      <Button key='save' type='primary'
        onClick={() => save()}
      >确定</Button>
    ]
  }, [close, save])

  return (
    <Modal
      visible={visible}
      footer={footer}
      width='80%'
      bodyStyle={{ padding: '15px', overflowX: 'auto', maxHeight: '80vh' }}
      title='编辑检查规则'
      centered destroyOnClose
      onCancel={() => { close() }}
    >
      <Spin spinning={waiting}>
        <Basic ref={basicRef} item={item} />
      </Spin>
    </Modal>
  )
}

export default FC

export const Basic = React.forwardRef(function ({ type, item }, ref) {
  const [loadingStatus, setLoadingStatus] = React.useState(false)
  const [status, setStatus] = React.useState()
  const [loadingAlertTypes, setLoadingAlertTypes] = React.useState(false)
  const [alertTypes, setAlertTypes] = React.useState()
  const [form] = Form.useForm()

  React.useImperativeHandle(ref, () => ({
    validate: async () => {
      return await form?.validateFields()
    },
  }), [form])

  React.useEffect(() => {
    getStatus()
    getAlertTypes()
  }, [])

  React.useEffect(() => {
    if (item) {
      form?.setFieldsValue(item)
    }
  }, [item])

  const getStatus = () => {
    setLoadingStatus(true)
    dispatch({
      type: 'datamodel.getRuleStatus',
      callback: data => {
        setLoadingStatus(false)
        setStatus(data)
      },
      error: () => {
        setLoadingStatus(false)
      }
    })
  }

  const getAlertTypes = () => {
    setLoadingAlertTypes(true)
    dispatch({
      type: 'datamodel.getRuleAlertTypes',
      callback: data => {
        setLoadingAlertTypes(false)
        setAlertTypes(data)
      },
      error: () => {
        setLoadingAlertTypes(false)
      }
    })
  }

  const onValuesChange = (changedValues, allValues) => {

  }

  return (
    <Form
      form={form}
      labelCol={{ span: 3 }}
      wrapperCol={{ span: 21 }}
      autoComplete="off"
      onValuesChange={onValuesChange}
    >
      <Form.Item label='规则名称'
      >
        <span>{item?.ruleTemplateName}</span>
      </Form.Item>
      <Form.Item label='规则描述'
      >
        <span>{item?.ruleTemplateRemark}</span>
      </Form.Item>
      <Form.Item name='statusId' label='规则状态'
        rules={[{ required: true, message: '请选择规则状态!' }]}
      >
        <Select loading={loadingStatus} allowClear placeholder='请选择状态'>
          { (status??[]).map(item => ( <Select.Option key={item.id} value={item.id}>{item.name}</Select.Option> )) }
        </Select>
      </Form.Item>
      <Form.Item name='alertTypeId' label='规则类型'
        rules={[{ required: true, message: '请选择规则类型!' }]}
      >
        <Select loading={loadingAlertTypes} allowClear placeholder='请选择类型'>
          { (alertTypes??[]).map(item => ( <Select.Option key={item.id} value={item.id}>{item.name}</Select.Option> )) }
        </Select>
      </Form.Item>
      <Form.Item name='alertContent' label='规则提示'
        rules={[{ required: true, message: '请输入规则提示!' }]}
      >
        <Input allowClear placeholder='请输入规则提示' />
      </Form.Item>
    </Form>
  )
})