import React from 'react'
import classNames from 'classnames'
import { ResizableBox } from 'react-resizable'
import { CaretLeftOutlined, CaretRightOutlined } from '@ant-design/icons'

import Tree from './rule-tree'
import List from './rule-list'
import Separate from '../../AssetManage/Component/Separate'

import '../../AssetManage/index.less'

const FC = (props) => {
  const { readonly = false } = props
  const [node, setNode] = React.useState()

  const onTreeClick = (value) => {
    setNode(value)
  }

  return (
    <div className='asset-manage'>
      <div className='left' style={{ width: 230}}          
      >
        <Tree onClick={onTreeClick} {...props} />
      </div>
      <div className='middle'>
        <List node={node} {...props} />
      </div>
    </div>
  )
}

export default FC