import React from "react"
import { Modal } from "antd"

import RuleCURD from './rule'

const FC = (props) => {
  const { visible, onCancel } = props

  const close = () => {
    onCancel?.()
  }

  return (
    <Modal
      visible={visible}
      footer={null}
      width='80%'
      bodyStyle={{ padding: '15px', overflowX: 'auto', maxHeight: '80vh' }}
      title='规范详情'
      centered destroyOnClose
      onCancel={() => { close() }}
    >
      <RuleCURD readonly={true} />
    </Modal>
  )
}

export default FC