import React from 'react'
import { Drawer, Tabs } from 'antd'

import History from './rule-catalog-history'
import Compare from './rule-catalog-compare'

const FC = ({ visible, item, onCancel }) => {
  const close = () => {
    onCancel?.()
  }

  return (
    <Drawer 
      title=''
      placement="right"
      closable={true}
      width={'90%'}
      onClose={close}
      visible={visible}
      destroyOnClose
    >
      <Tabs defaultActiveKey="1" type="card" size='small'>
        <Tabs.TabPane tab="版本历史" key="1">
          <History item={item} />
        </Tabs.TabPane>
        <Tabs.TabPane tab="版本对比" key="2">
          <Compare item={item} />
        </Tabs.TabPane>
      </Tabs>
    </Drawer>
  );
}

export default FC;