import React from 'react';
import { Form, Input, Row, Col, Descriptions, Select } from 'antd';

import { dispatch } from '../../../../model'; 

const { TextArea } = Input;

const TemplateActionHeader = (props) => {
  const { editable, form, templateData, onChange } = props;

  const [loadingDbTypes, setLoadingDbTypes] = React.useState(false);
  const [dbTypes, setDbTypes] = React.useState();

  React.useEffect(() => {
    getDbTypes()
  }, [])

  const getDbTypes = () => {
    setLoadingDbTypes(true)
    dispatch({
      type: 'datamodel.getDbTypes',
      callback: data => {
        setLoadingDbTypes(false)
        setDbTypes(data)
      },
      error: () => {
        setLoadingDbTypes(false)
      }
    })
  }

  const formItemLayout = {
    labelCol: {
      xs: { span: 24 },
      sm: { span: 5 },
    },
    wrapperCol: {
      xs: { span: 24 },
      sm: { span: 19 },
    },
  };

  const onValuesChange = (changedValues, allValues) => {
    onChange && onChange(allValues)
  }

  return (
    <>
    {
      editable ? (
        <Form
          form={form}
          {...formItemLayout}
          onValuesChange={onValuesChange}
          style={{ overflow: 'hidden' }}
        >
          <Row gutter={10}>
            <Col span={12}>
              <Form.Item
                label='数据库类型'
                labelAlign="left"
                name="dbType"
                rules={[{ required: true, message: '请选择数据库类型!' }]}
              >
                {
                  !templateData?.id ? <Select loading={loadingDbTypes}>
                    { dbTypes?.map(item => <Select.Option key={item} value={item}>{item}</Select.Option>) }
                  </Select> : <span className='word-wrap'>
                    {templateData?.dbType}
                  </span>
                }
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item
                label="中文名称"
                name="cnName"
                labelAlign="left"
                rules={[{ required: true, message: '请输入中文名称!' }]}
              >
                <Input />
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item
                label="英文名称"
                name="name"
                labelAlign="left"
                rules={[{ required: true, message: '请输入英文名称!' }]}
              >
                <Input />
              </Form.Item>
            </Col>
            <Col span={12}>
              <Form.Item
                label="描述"
                name="remark"
                labelAlign="left"
                rules={[{ required: true, message: '请输入描述!' }]}
              >
                <TextArea row={4} />
              </Form.Item>
            </Col>
          </Row>
        </Form> 
      ) : (
        <Descriptions column={2}>
          <Descriptions.Item label="数据库类型">{templateData.dbType||''}</Descriptions.Item>
          <Descriptions.Item label="中文名称">{templateData.cnName||''}</Descriptions.Item>
          <Descriptions.Item label="英文名称">{templateData.name||''}</Descriptions.Item>
          <Descriptions.Item label="描述">{templateData.remark||''}</Descriptions.Item>
        </Descriptions>
      ) 
    }   
    </>
  )
}

export default TemplateActionHeader;