import React, { useState, useEffect } from 'react';
import { Button, Upload, Form } from 'antd';
import { UploadOutlined } from '@ant-design/icons';

const ImportWord = (props) => {
  const { onChange, visible } = props;
  const [ fileList, setFileList ] = useState([]);

  useEffect(() => {
    setFileList([]);
  }, [visible])

  const normFile = () => {
    return fileList;
  }

  const uploadProps = {
    onRemove: file => {

      const index = fileList.indexOf(file);
      const newFileList = fileList.slice();
      newFileList.splice(index, 1);

      onChange && onChange(newFileList);

      setFileList(newFileList);
    },
    beforeUpload: file => {
      
      setFileList([file]);
      return false;
    },
    fileList: fileList||[],
    accept:".doc,.docx",
  };

  return (
    <Form.Item 
      name='upload'
      label='文件上传' 
      valuePropName="fileList"
      getValueFromEvent={normFile}
      rules={[
        {
          required: true,
          message: '请选择文件上传',
        },
      ]}
    >
      <Upload {...uploadProps}>
        <Button icon={<UploadOutlined />}>
          选择文件上传
        </Button>
      </Upload>
    </Form.Item>
  )
}

export default ImportWord;