import React from "react"
import { Button, Descriptions, Space, Popover } from "antd"
import { DownOutlined, UpOutlined, QuestionCircleOutlined } from '@ant-design/icons'

import { Action, ModelerId, PermitCheckOut, Editable, StateId, Holder, ReadOnly } from '../../../../util/constant'

export const inheritanceHistoricalType = 'historical'
export const inheritanceZipperType = 'zipper'

const FC = (props) => {
  const { modelerData, action } = props
  const [isCollapse, setCollapse] = React.useState(true)
  const [relationModelerDatas, setRelationModelerDatas] = React.useState([])

  React.useEffect(() => {
    if (modelerData?.inheritedFromEasyDataModelerDataModel) {
      const newRelationModelerDatas = [];
      
      newRelationModelerDatas.push(modelerData?.inheritedFromEasyDataModelerDataModel);
      
      if (modelerData?.otherEasyDataModelerDataModelsInheritedFromSameOrigin) {
        Object.keys(modelerData.otherEasyDataModelerDataModelsInheritedFromSameOrigin).forEach(key => {
          newRelationModelerDatas.push(modelerData.otherEasyDataModelerDataModelsInheritedFromSameOrigin[key]);
        })
      }
      
      setRelationModelerDatas(newRelationModelerDatas);
    } else {
      const newRelationModelerDatas = [];
      if (modelerData?.inheritedEasyDataModelerDataModels?.historical) {
        newRelationModelerDatas.push(modelerData?.inheritedEasyDataModelerDataModels?.historical);
      }
      if (modelerData?.inheritedEasyDataModelerDataModels?.zipper) {
        newRelationModelerDatas.push(modelerData?.inheritedEasyDataModelerDataModels?.zipper);
      }

      setRelationModelerDatas(newRelationModelerDatas);
    }
    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [modelerData])

  return (
    <div>
      <div className='model-import-action-relation mb-3'>
        <Space>
          <h3 style={{ marginBottom: 0 }}>关联对象</h3>
          { 
            action==='add' && <Popover content='保存当前模型后方可选择历史存储形式'>
              <QuestionCircleOutlined className='pointer' /> 
            </Popover> 
          }
          {
            isCollapse ? <Button type='primary' size='small' onClick={() => {
              setCollapse(!isCollapse)
            }}>展开<DownOutlined /></Button> : <Button type='primary' size='small' onClick={() => {
              setCollapse(!isCollapse)
            }}>收起<UpOutlined /></Button>
          }
        </Space>
      </div>
      {
        !isCollapse && <Descriptions column={3}>
          <Descriptions.Item 
            label={
            <div style={{ textAlign: 'right', width: 100 }}>
              历史存储形式
            </div>} 
          >
            <span>
            {
              relationModelerDatas?.length===0 ? '暂无信息' : 
                relationModelerDatas?.map((item, index) => (
                <a className='mr-3' key={index} onClick={() => {
                  window.open(`/data-govern/data-model-action?${Action}=detail&${ModelerId}=${item.id}&${PermitCheckOut}=${item.permitCheckOut||false}&${Editable}=${item.editable||false}&${StateId}=${item.state?.id||''}&${Holder}=${item.holder||''}&${ReadOnly}=false`);
                }}>
                {item.cnName}
                </a>
              ))
            }
            </span>
          </Descriptions.Item> 
        </Descriptions> 
      }
    </div>
  )
}

export default FC