import React from 'react'
import { Button, Form, Descriptions, Input, Row, Col } from 'antd'
import { DownOutlined, UpOutlined } from '@ant-design/icons'
import { Subject } from 'rxjs';

import { dispatch } from '../../../../model'

export const ImportActionHeaderSubject = new Subject();

const FC = (props) => {
  const { editable, form, modelerData } = props
  const [isCollapse, setCollapse] = React.useState(true)
  const [maintenanceRecords, setMaintenanceRecords] = React.useState()

  React.useEffect(() => {
    if (modelerData?.id) {
      getMaintenanceRecords()
    }

    const $$header = ImportActionHeaderSubject.subscribe((act) => {
      if (act?.type === 'refreshMaintenanceRecords') {
        getMaintenanceRecords();
      } 
    })
    return () => {
      $$header.unsubscribe()
    }
  }, [modelerData])

  const maintenanceDescription = React.useMemo(() => {
    if ((maintenanceRecords??[]).length>0) {
      let newDescription = ''
      for (const [index, record] of maintenanceRecords.entries()) {
        if (index !== 0) {
          newDescription += '/'
        }
        newDescription += record
      }
      
      return newDescription
    }
    return ''
  }, [maintenanceRecords])

  const getMaintenanceRecords = () => {
    dispatch({
      type: 'datamodel.getMaintenanceRecords',
      payload: {
        id: modelerData?.id
      },
      callback: data => {
        setMaintenanceRecords(data);
      }
    })
  }

  const formItemLayout = {
    labelCol: {
      xs: { span: 24 },
      sm: { span: 6 },
    },
    wrapperCol: {
      xs: { span: 24 },
      sm: { span: 18 },
    },
  };

  return (
    <div>
      <div className='model-import-action-manage mb-3' style={{ 
          display: 'flex',
          alignItems: 'center',
        }}
      >
        <h3 className='mr-3' style={{ marginBottom: 0 }}>管理信息</h3>
        {
          isCollapse ? <Button type='primary' size='small' onClick={() => {
            setCollapse(!isCollapse)
          }}>展开<DownOutlined /></Button> : <Button type='primary' size='small' onClick={() => {
            setCollapse(!isCollapse)
          }}>收起<UpOutlined /></Button>
        }
      </div>
      {
        !isCollapse && <Descriptions column={1}>
          <Descriptions.Item label={<div style={{ textAlign: 'right', width: 85 }} >维护历史</div>} >
            <div style={{ maxHeight: 110, overflow: 'auto' }}>
            {
              (maintenanceRecords||[]).map((record, index) => {
                return <div key={index}>{record||''}</div>;
              })
            }
            </div>
          </Descriptions.Item> 
        </Descriptions>
      }
    </div>
  )
}

export default FC