import React from 'react';
import { Drawer, Tabs } from 'antd';

import VersionHistory from './VersionHistory';
import VersionCompare from './VersionCompare';

const { TabPane } = Tabs;

const HistoryAndVersionDrawer = (props) => {
  const { onCancel, visible, id } = props;

  return (
    <Drawer 
      title=''
      placement="right"
      closable={true}
      width={'90%'}
      onClose={() => {
        onCancel && onCancel();
      }}
      visible={visible}
    >
    {
      visible && <Tabs defaultActiveKey="1" type="card" size='small'>
        <TabPane tab="版本历史" key="1">
          <VersionHistory id={id} />
        </TabPane>
        <TabPane tab="版本对比" key="2">
          <VersionCompare id={id} />
        </TabPane>
      </Tabs>
    }
    </Drawer>
  );
}

export default HistoryAndVersionDrawer;