import React from 'react';
import { Spin, Radio, Tooltip, Tag } from 'antd';

import MapContent from './MapContent';
import { dispatchLatest } from '../../../model';

import './index.less';

const { CheckableTag } = Tag;

const graphModes = [
  {
    title: '方块图',
    key: 'square'
  },
  {
    title: '组织图',
    key: 'org',
  },
  {
    title: '树形图',
    key: 'tree',
  },
  {
    title: '关系图',
    key: 'relation'
  }
];

class Map extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      type: 'square',
      tabKey: '',
      loadingTopics: false,
      resourceTopics: null,
      assetTopics: null,
      selectedTopic: {}
    };
  }

  componentDidMount() {

    this.setState({ loadingTopics: true }, () => {
      dispatchLatest({
        type: 'map.getAllTopics',
        payload: null,
        callback: data => {
          this.setState({
            loadingTopics: false,
            resourceTopics: (data||[]).filter(item=>(item.code==='001'||item.code==='002')),
            assetTopics: (data||[]).filter(item=>(item.code!=='001'&&item.code!=='002')),
            selectedTopic: (data||[]).length>0?data[0]:{}
          });
        },
        error: () => {
          this.setState({ loadingTopics: false });
        }
      })
    })
  }

  onTypeChange = e => {
    this.setState({ type: e.target.value });
  };

  onTabChange = activeKey => {
    this.setState({ tabKey: activeKey });
  }

  onTagChange = (item, checked) => {
    if (checked) {
      this.setState({ selectedTopic: item });
    }
  }

  render() {
    const { type, resourceTopics, assetTopics, loadingTopics, selectedTopic } = this.state;

    const switchMode = <div className=''>
      <Radio.Group
        value={type}
        onChange={this.onTypeChange} size="small"
      >
        {
          graphModes && graphModes.map((mode, index) => {
            return (
              <Tooltip key={index} title={mode.title || ''} >
                <Radio.Button value={mode.key}>{(mode.title || '').substring(0, 1)}</Radio.Button>
              </Tooltip>
            );
          })
        }
      </Radio.Group>
    </div>


    return (
      <div className='asset-map' style={{ backgroundColor: '#fff' }}>
        {
          loadingTopics ? <Spin /> : <>
            <div 
              className='flex' 
              style={{ 
                alignItems: 'center', 
                justifyContent: 'space-between', 
                height: 64, 
                borderBottom: '1px solid #f0f0f0', 
                margin: '0px 10px' 
              }}
            >
              <div>
                <span>数据资源: </span>
                {
                  resourceTopics && resourceTopics.map(item => {
                    return (
                      <CheckableTag
                        key={item.id}
                        checked={selectedTopic?.id===item.id}
                        onChange={checked => this.onTagChange(item, checked)}
                      >
                        {item.name}
                      </CheckableTag>
                    );
                  })
                }
              </div>
              <div>
                <span>数据资产: </span>
                {
                  assetTopics && assetTopics.map(item => {
                    return (
                      <CheckableTag
                        key={item.id}
                        checked={selectedTopic?.id===item.id}
                        onChange={checked => this.onTagChange(item, checked)}
                      >
                        {item.name}
                      </CheckableTag>
                    );
                  })
                }
              </div>
            </div>
            <div className='map-container' >
              <MapContent type={type} topic={selectedTopic} switchMode={switchMode} {...this.props} />
            </div>
          </>
        }
      </div>
    );
  }
}

export default Map;