import React from 'react';
import { Chart } from '@antv/g2';

class Bar extends React.Component {

  componentDidMount() {
    const { data, type } = this.props;

    setTimeout(() => {
      const chart = new Chart({
        container: `bar${type||''}`,
        autoFit: true,
      });
      
      chart.data(data);
      chart.scale('value', {
        nice: true,
      });
      
      chart.tooltip({
        showMarkers: false
      });
      chart.interaction('active-region');
      
      chart.interval().position('name*value');
      
      chart.render();
    }, 100);
  }

  render() {
    const { type } = this.props;
    return (
      <div id={`bar${type||''}`} style={{ width: '100%', height: 150 }}></div>
    )
  }

}

export default Bar;