import React, { useMemo } from 'react';
import { Modal, Divider, Descriptions, Button, Table, Row, Col } from 'antd';
import { DownloadOutlined } from '@ant-design/icons';
import LocalStorage from 'local-storage';

import { status } from '.';

const FC = (props) => {
  const { visible, onCancel, task } = props;

  return (
    <Modal 
      visible={visible}
      title={`${task?.title}详情`}
      width={1000}
      onCancel={() => onCancel?.()}
      footer={
        <Button onClick={() => onCancel?.() }>取消</Button>
      }
    >
      <AuditProgress task={task} />
      <Basic task={task} />
      <Process task={task} />
      <Template task={task} />
    </Modal>
  );
}

export default FC;

export const AuditProgress = ({ task }) => {
  const auditStatus = useMemo(() => {
    return ['分发', '提交', '审核'];
  }, [])

  const backgroundColor = '#F5F5F5';
  const hightBackgroundColor = '#2E90F1';

  const stateCompleted = (state) => {
    const index = task?.contents?.filter(item => item.status==='1').findIndex(item => item.title.indexOf(state)!==-1);
    return (index !== -1);
  }

  const stateContent = (state) => {
    return task?.contents?.filter(item => item.status==='1').find(item => item.title.indexOf(state)!==-1);
  }

  const leftLineColor = (state) => {
    const index = task?.contents?.filter(item => item.status==='1').findIndex(item => item.title.indexOf(state)!==-1);
    return (index !== -1) ? hightBackgroundColor : backgroundColor;
  }

  const rightLineColor = (state) => {
    const index = auditStatus.findIndex(item => item === state);
    if (index === auditStatus.length -1) {
      return hightBackgroundColor;
    } else {
      return leftLineColor(auditStatus[index+1]);
    }
  }

  return (
    <React.Fragment>
      <Divider>审批进度</Divider>
      <Row>
      {
        auditStatus.map((item, index) => {
          return (
            <Col span={24/auditStatus.length} key={index} style={{ height: 6 }} >
            {
              <Row align='middle'>
                <Col span={11} style={{ backgroundColor: leftLineColor(item), height: 4, visibility: (index===0?'hidden':'visible') }}></Col>
                <Col span={2} className='flex' style={{ justifyContent: 'center' }} >
                  <div style={{ backgroundColor: leftLineColor(item), width: 16, height: 16, borderRadius: '50%' }}></div>
                </Col>
                <Col span={11} style={{ backgroundColor: rightLineColor(item), height: 4, visibility: (index===auditStatus.length-1?'hidden':'visible')  }}></Col>
              </Row>
            }
            </Col>
          )
        })
      } 
      </Row>
      <Row className='pt-3'>
      {
        auditStatus.map((item, index) => {
          const currentContent = stateContent(item);

          return (
            <Col span={24/auditStatus.length} key={index} >
              <div style={{ textAlign: 'center' }}>
                <div>{item}</div>
                {
                  stateCompleted(item) && <React.Fragment>
                    <div>{`审批人: ${currentContent.dealUser}`}</div>
                    <div>{`审批状态: ${currentContent.status==='1'?'通过':'不通过'}`}</div>
                    <div>{`审批意见: ${currentContent.value}`}</div>
                    <div>{`审批日期: ${currentContent.processDate}`}</div>
                  </React.Fragment>
                }
              </div> 
            </Col>
          )
        })
      } 
      </Row>
    </React.Fragment>
  )
}

export const Basic = ({ task }) => {
  return (
    <React.Fragment>
      <Divider>基本信息</Divider>
      <Descriptions title="" labelStyle={{ fontWeight: 'bold' }}>
        <Descriptions.Item label="任务ID">{task?.id}</Descriptions.Item>
        <Descriptions.Item label="任务标题">{task?.title}</Descriptions.Item>
        <Descriptions.Item label="任务说明">{task?.comment}</Descriptions.Item>
        <Descriptions.Item label="任务状态">{status[task?.status]}</Descriptions.Item>
        <Descriptions.Item label="所属部门">{task?.department?.groupDisplayName??task?.department?.groupName}</Descriptions.Item>
        <Descriptions.Item label="资产专员">{task?.specialist?.userDisplayName??task?.specialist?.userName}</Descriptions.Item>
        <Descriptions.Item label="更新日期">{task?.updateTime}</Descriptions.Item>
        <Descriptions.Item label="更新人">{task?.updateUser?.userDisplayName??task?.updateUser?.userName}</Descriptions.Item>
        <Descriptions.Item label="创建日期">{task?.createTime}</Descriptions.Item>
        <Descriptions.Item label="创建人">{task?.createUser?.userDisplayName??task?.createUser?.userName}</Descriptions.Item>
      </Descriptions>
    </React.Fragment>
  )
}

export const Process = ({ task }) => {
  const columns = useMemo(() => {
    return [
      {
        title: '处理人',
        dataIndex: 'dealUser',
        ellipsis: true,
      },
      {
        title: '处理时间',
        dataIndex: 'processDate',
        ellipsis: true,
      },
      {
        title: '状态',
        dataIndex: 'status',
        ellipsis: true,
        render: (state, _) => (state==='1')?'通过':'驳回'
      },
      {
        title: '答复内容',
        dataIndex: 'content',
        ellipsis: true,
        render: (_, record) => `${record.title}意见: ${record.value}`
      }
    ]
  }, [])

  return (
    <React.Fragment>
      <Divider>审批过程</Divider>
      {
        task?.contents?.length === 0 ? <span>暂无审批过程</span> : <Table
          width={980}
          maxHeight='300px'
          columns={columns}
          dataSource={task?.contents||[]}
          pagination={false}
        />
      }
    </React.Fragment>
  )
}

export const Template = ({ task }) => {
  const downloadTemplate = () => {
    const env = LocalStorage.get('assetsEnv');
    window.open(`/api/dataassetmanager/dataAssetCheckApi/getFileById?env=${env}&fileId=${task?.dataAssetExcel?.fileId}`);
  }

  return (
    <React.Fragment>
      <Divider>任务内容</Divider>
      {
        task?.dataAssetExcel ? <Button className='mr-2' icon={<DownloadOutlined />} onClick={ downloadTemplate }>
        {`${task?.dataAssetExcel?.fileName}下载`}
        </Button>  : <span>暂无任务内容</span>
      }
    </React.Fragment>
  )
}