import React, { useEffect, useState, useContext } from 'react';
import { Modal, Form, Input, Select, Space, Button, Upload } from 'antd';
import { UploadOutlined, DownloadOutlined } from '@ant-design/icons';
import LocalStorage from 'local-storage';

import { AppContext } from '../../../App';
import { dispatch } from '../../../model';
import { showMessage } from '../../../util';
import { AuditProgress, Basic, Process, Template } from './TaskDetail';

const FC = (props) => {
  const { visible, onCancel, task } = props;

  const [form] = Form.useForm();
  const [confirmLoading, setConfirmLoading] = useState(false);
  const [ fileList, setFileList ] = useState([]);

  const { user } = useContext(AppContext);

  const downloadTemplate = () => {
    const env = LocalStorage.get('assetsEnv');
    window.open(`/api/dataassetmanager/dataAssetCheckApi/getDataAssetTemplate?env=${env}`);
  }

  const uploadProps = {
    onRemove: file => {
      const index = fileList.indexOf(file);
      const newFileList = fileList.slice();
      newFileList.splice(index, 1);

      setFileList(newFileList);
    },
    beforeUpload: file => {

      const isLt2OM = file.size / 1024 / 1024 < 20;
      if (!isLt2OM) {
        showMessage('error', '上传文件必须小于20M');
        setFileList([]);
        return false;
      }

      setFileList([file]);
      return false;
    },
    fileList: fileList || [],
    accept:".xlsx",
  };

  const handleOk = async (status = '-1') => {
    if ((fileList||[]).length === 0) {
      showMessage('info', '请先上传盘点文件');
      return;
    }
    
    setConfirmLoading(true);
    dispatch({
      type: 'assetmanage.uploadDataAssetExcel',
      payload: { fileList: fileList },
      callback: fileId => {
        setConfirmLoading(false);
        dispatch({
          type: 'assetmanage.saveTask',
          payload: {
            data: {
              ...task,
              dataAssetExcel: {
                fileId,
                fileName: fileList[0].name
              }
            }
          },
          callback: data => {
            setConfirmLoading(false);
            reset();
            onCancel?.(true);
          },
          error: () => {
            setConfirmLoading(false);
          }
        });
      },
      error: () => {
        setConfirmLoading(false);
      }
    });
  }

  const reset = () => {
    setConfirmLoading(false);
    setFileList([]);
  }

  return (
    <Modal 
      visible={visible}
      title={`盘点${task?.title}`}
      width={1000}
      confirmLoading={confirmLoading}
      onCancel={() => {
        reset();
        onCancel && onCancel();
      }}
      footer={
        <Space>
          <Button onClick={() => onCancel && onCancel() }>取消</Button>
          <Button type="primary" onClick={() => {handleOk()}} loading={confirmLoading}>确定</Button>
        </Space>
      }
    >
      <Form layout='inline'>
        <Form.Item label='盘点文件上传:'>
          <Button className='mr-2' icon={<DownloadOutlined />} onClick={ downloadTemplate }>
          模版下载
          </Button>
          <Upload style={{ display: 'inline' }} {...uploadProps }>
            <Button icon={
              <UploadOutlined />}>
              选择文件上传
            </Button>
          </Upload>
        </Form.Item>
      </Form>

      <AuditProgress task={task} />
      <Basic task={task} />
      <Process task={task} />
      <Template task={task} />
    </Modal>
  );
}

export default FC;