import React, { useState } from 'react';
import classNames from 'classnames';
import { Form } from 'antd';
import { CaretLeftOutlined, CaretRightOutlined } from '@ant-design/icons';
import { ResizableBox } from 'react-resizable';

import AssetTree from './Component/AssetManageTree';
import AssetDirectory from './Component/AssetDirectory';
import AssetTable from './Component/AssetTable';
import AssetAction from './Component/AssetAction';
import Separate from './Component/Separate';

import { AssetManageReference } from '../../../util/constant';

import './index.less';

const AssetManage = (props) => {
  const [ nodeId, setNodeId ] = useState(null);
  const [ nodeType, setNodeType ] = useState('');
  const [ nodeLevel, setNodeLevel ] = useState(null);
  const [ assetParams, setAssetParams ] = useState({ assetId: '', assetDirId: '' })
  const [ expandTree, setExpandTree ] = useState(true);
  const [ assetFullScreen, setAssetFullScreen ] = useState(false);

  const [ assetCount, setAssetCount ] = useState(0);
  const [ directoryChanged, setDirectoryChanged ] = useState(false);
  const [ elementsChanged, setElementsChanged ] = useState(false);
  const [ assetActionChanged, setAssetActionChanged ] = useState(false);
  const [ form ] = Form.useForm();

  const { assetId, assetDirId } = assetParams;

  const onTreeSelect = (value, type, level) => {
    setNodeId(value);
    setNodeType(type);

    setNodeLevel(level);
  }

  const onTableSelect = (id, did) => {
    setAssetParams({ assetId: id, assetDirId: did });
  }

  const treeToggleClick = () => {
    setExpandTree(!expandTree);
  }

  const onElementsChange = () => {
    setElementsChanged(!elementsChanged);
  }

  const onDirectoryChange = () => {
    setDirectoryChanged(!directoryChanged);
  }

  const onAssetActionChange = () => {
    setAssetActionChanged(!assetActionChanged);
  }

  const onAssetCountChange = (count) => {
    setAssetCount(count);
  }

  const onFullScreenChange = (value) => {
    setAssetFullScreen(value);
  }

  const classes = classNames('asset-manage', {
    'asset-manage-collapse': !expandTree
  });  

  const middleClasses = classNames('middle', {
    'middle-fullscreen': assetFullScreen
  });  

  return (
    <div className={classes}>
      <ResizableBox 
        className='left' 
        width={230} 
        height={Infinity}
        axis='x'
        minConstraints={[230, Infinity]} maxConstraints={[Infinity, Infinity]}          
      >
        <AssetTree onSelect={onTreeSelect} onDirectoryChange={onDirectoryChange} {...props} />
      </ResizableBox>
      {
        expandTree && <Separate width={15} />
      }
      <div className={middleClasses}>
        {/* <AssetDirectory id={nodeId} assetCount={assetCount} directoryChanged={directoryChanged} onElementsChange={onElementsChange} />
        <Separate height={15} /> */}
        <AssetTable nodeId={nodeId} nodeType={nodeType} nodeLevel={nodeLevel} reference={AssetManageReference} elementsChanged={elementsChanged} assetActionChanged={assetActionChanged} onSelect={onTableSelect} onCountChange={onAssetCountChange} onFullScreenChange={onFullScreenChange} {...props} />
        <div className='tree-toggle' onClick={treeToggleClick}>
        { expandTree ? <CaretLeftOutlined /> : <CaretRightOutlined /> }
        </div>
      </div>
      {/* <Separate width='15px' />
      <div className='right'>
        <AssetAction form={form} id={assetId} dirId={assetDirId} action='detail' onChange={onAssetActionChange} />
      </div> */}
    </div>
  )
}

export default AssetManage;