import React, { useState, useContext } from 'react';
import { Modal, Form, Input } from 'antd';

import { dispatchLatest } from '../../../../model';
import { showNotifaction } from '../../../../util';
import { AppContext } from '../../../../App';

const StartFlowModal = (props) => {
  const { visible, onCancel, ids } = props;

  const [ form ] = Form.useForm();
  const [ confirmLoading, setConfirmLoading ] = useState(false);

  const app = useContext(AppContext);

  const formItemLayout = {
    labelCol: {
      xs: { span: 24 },
      sm: { span: 4 },
    },
    wrapperCol: {
      xs: { span: 24 },
      sm: { span: 20 },
    },
  };

  const handleOk = async () => {

    try {
      const values = await form.validateFields();

      setConfirmLoading(true);

      dispatchLatest({
        type: 'assetmanage.startFlow',
        payload: {
          params: {
            env: app?.env?.domainId,
            dataAssetIds: ids.join(','),
            applyReason: values?.desc
          }
        },
        callback: data => {
          reset();
          
          if (data) {
            showNotifaction('申请提示', (data === 'ok')?'资产目录申请成功，请在我的流程》我的申请中查看详情':data, 5);
          }
          
          onCancel && onCancel(true);
        },
        error: () => {
          setConfirmLoading(false);
        }
      })

    } catch (errInfo) {

    }
  }

  const reset = () => {
    setConfirmLoading(false);
    form.resetFields();
  }

  return (
    <Modal 
      forceRender
      visible={visible}
      title='资产目录申请'
      width={520}
      confirmLoading={confirmLoading}
      onCancel={() => {
        reset();
        onCancel && onCancel();
      }}
      onOk={handleOk}
    >
    <Form 
      {...formItemLayout}
      form={form}
    >
      <Form.Item 
        label="申请原因" 
        name="desc" 
        rules={[{ required: true, message: '请在申请原因栏中描述用途说明以及必要性（资产目录和服务权限申请需要说明请求字段）' }]}
      >
        <Input.TextArea rows={6} />
      </Form.Item>
    </Form>
    </Modal>
  );
}

export default StartFlowModal;