import React from 'react';
import { Button } from 'antd';
import { SettingFilled } from '@ant-design/icons';

import { highlightSearchContentByTerms } from '../../../../util';
import { AppContext } from '../../../../App';

const MetadataInfo = ({ value = '', config = true, terms = [] }) => {
  
  let metadata = {};
  try {
    metadata = JSON.parse(value);
  } catch(error) {
    metadata = value;
  }

  return (
    <AppContext.Consumer>
    {
      value => <div className='flex'>
        {
          (typeof metadata==='string') ? <span style={{ marginRight: 5 }}>{highlightSearchContentByTerms(metadata||'', terms)}</span> : <div className='flex' style={{ flexDirection: 'column' }}>
            <a onClick={() => {
              value?.setGlobalState && value?.setGlobalState({
                message: 'data-govern-show-metadata-message',
                data: metadata
              })
            }} style={{ marginRight: 5, marginTop: config?5:0 }}>{highlightSearchContentByTerms(metadata?.tableName||'',terms)}
            </a>
            {
              (metadata?.columnItems||[]).map((item, index) => {

                let _content = '';
                if ((item.metadataColumnCnName||'')!=='') {
                  _content = item.metadataColumnCnName + '/';
                }

                _content += item.metadataColumnName||'';

                return <span key={index}>{highlightSearchContentByTerms(_content,terms)}</span>
              })
            }
          </div>
        }
        {
          config && <Button icon={<SettingFilled />} onClick={() => {
            value?.setGlobalState && value?.setGlobalState({
              message: 'data-govern-show-metadata-list-message',
              data: (typeof metadata==='string') ? {} : metadata 
            })
          }} />
        }
      </div>
    }
    </AppContext.Consumer>
  );
}

export default MetadataInfo;