import React from 'react';

import { highlightSearchContentByTerms } from '../../../../util';
import { AppContext } from '../../../../App';

const FC = ({ value = '', terms = [] }) => {
  return (
    <AppContext.Consumer>
    {
      appValue => <a onClick={() => {
        appValue?.setGlobalState && appValue?.setGlobalState({
          message: 'data-govern-show-index-detail-message',
          data: { name: value } 
        })
      }}>
        <span>{highlightSearchContentByTerms(value, terms)}</span>
      </a>
    }
    </AppContext.Consumer>
  );
}

export default FC;