import React, { useEffect, useState } from "react";
import LocalStorage from 'local-storage';
import { Spin } from "antd";

import AssetAction from "./AssetAction";
import { getQueryParam } from '../../../../util';
import { dispatch } from '../../../../model';

import './AssetDetailPage.less';
import { getDataAssetDetail } from "../../../../service/dataassetmanager";
import { appId } from "../../../../App";

const AssetDetailPage = (props)=>{

  const [ data, setData ] = useState({ id: '', dirId: '' });
  const [loading, setLoading] = useState(false)
  const [templateType, setTemplateType] = useState()
  const { id, dirId } = data;
  
  useEffect(() => {

    const _id = getQueryParam('id', props.location.search);
    const _dirId = getQueryParam('dirId', props.location.search);
    setData({ id: _id, dirId: _dirId });
    getDataAssetDetail()

    //eslint-disable-next-line react-hooks/exhaustive-deps
  }, [])

  const getDataAssetDetail = () => {
    const _id = getQueryParam('id', props.location.search);
    const _dirId = getQueryParam('dirId', props.location.search);

    dispatch({
      type: 'assetmanage.getDataAssetDetail',
      payload: {
        dataAssetId: _id,
        dirId: _dirId||'',
        checkPermission: true
      },
      callback: data => {
        setLoading(false);
        LocalStorage.set(`templateType-${appId}`, data?.templateType)
        setTemplateType(data?.templateType)
      },
      error: () => {
        setLoading(false);
      }
    })
  }
  

  return(
    <div className='asset-detail position-relative'>
      <div className='detail-header'>
        <span style={{ fontSize: 16, fontWeight: 'bold', color: '#000' }}>资产目录详情</span>
      </div>
      <Spin spinning={loading}>
        <div className='detail-container'>
          <div className='detail-container-card'>
          {
            templateType && <AssetAction id={id} dirId={dirId} action='detail' />
          }
          </div>
        </div>
      </Spin>
    </div>
  )
}

export default AssetDetailPage;