import React from 'react';
import { Drawer, Form } from 'antd';
import { getTemplateType } from '../../../../util/axios';
import AssetAction from './AssetAction';

const AssetDetailDrawer = (props) => {
  const { onCancel, visible, id, dirId, reference, templateType='', draftId='' } = props;
  const [ form ] = Form.useForm();
  const currentTemplateType = templateType || getTemplateType();
  return (
    <Drawer 
      visible={ visible }
      title='资产目录详情'
      width='80%'
      placement="right"
      closable={ true }
      destroyOnClose
      onClose={() => {
        onCancel && onCancel();
      }}
    >
    {
      visible && <AssetAction templateType={currentTemplateType} reference={reference} form={form} id={id} dirId={dirId} draftId={draftId} action='detail' onChange={() => {
        onCancel?.(true);
      }} />
    }
    </Drawer>
  )
}

export default AssetDetailDrawer;