import { useState } from "react";
import { Modal, Radio, Popover } from "antd";

import { QuestionCircleOutlined } from '@ant-design/icons';

const AssetDeleteModal = (props) => {
  const { visible, onCancel, onDelete, onDeleteAll } = props;
  const [ value, setValue ] = useState(1);

  const onChange = (e) => {
    setValue(e.target.value);
  };
  
  return (
    <Modal
      title="删除资产目录"
      visible={visible}
      width={530}
      onCancel={
        () => {
          onCancel && onCancel();
        }
      }
      onOk={
        () => {
          if (value === 1) {
            onDelete && onDelete();
          } else {
            onDeleteAll && onDeleteAll();
          }
        }
      }
    >
      <Radio.Group onChange={onChange} value={value}>
        <Radio value={1}>
          <span>删除本目录下的资产目录</span>
          &nbsp;
          <Popover content={
              <span>
                当要删除的资产目录,只存在一个目录时,删除该资产目录并且设置为未分类资产目录;<br/>
                存在多个目录时,只删除该目录下的这项资产目录,不会设置为未分类资产目录
              </span>
            }
          >
            <QuestionCircleOutlined className='pointer' /> 
          </Popover>
        </Radio>
        <Radio value={2}>
          <span>删除该资产目录(所有目录下的资产目录均删除)</span>
          &nbsp;
          <Popover content='该资产目录所在的目录内,均删除该项资产目录,并设置为未分类资产目录' >
            <QuestionCircleOutlined className='pointer' /> 
          </Popover>
        </Radio>
      </Radio.Group>
    </Modal>
  );
}

export default AssetDeleteModal;