import React, { useState } from 'react';
import classNames from 'classnames';
import { CaretLeftOutlined, CaretRightOutlined } from '@ant-design/icons';
import { ResizableBox } from 'react-resizable';

import AssetTree from '../AssetManage/Component/AssetTree';
import AssetDirectory from '../AssetManage/Component/AssetDirectory';
import RelationContainer from './Component/RelationContainer';
import AssetTable from "../AssetManage/Component/AssetTable";
import Separate from '../AssetManage/Component/Separate';

import { AssetBrowseReference } from '../../../util/constant';

import './index.less';

const AssetBrowse = (props) => {

  const { reference = AssetBrowseReference } = props;

  const [ nodeParams, setNodeParams ] = useState({ centerId: null, expandId: '', nodeType: '' });
  const [ expandTree, setExpandTree ] = useState(true);
  const [ expandRelation, setExpandRelation ] = useState(true);
  const [ assetCount, setAssetCount ] = useState(0);
  const [ resizeRelation, setResizeRelation ] = useState(false);
  const [ assetFullScreen, setAssetFullScreen ] = useState(false);

  const { centerId, expandId } = nodeParams;

  const onTreeSelect = (value, type) => {
    setNodeParams({ centerId: value, expandId: '', nodeType: type });
  }

  const treeToggleClick = () => {
    setExpandTree(!expandTree);
    setResizeRelation(!resizeRelation);
  }

  const relationToggleClick = () => {
    setExpandRelation(!expandRelation);
    setResizeRelation(!resizeRelation);
  }

  const onRelationChange = (data) => {
    setNodeParams(data);
  }

  const onAssetCountChange = (count) => {
    setAssetCount(count);
  }

  const onFullScreenChange = (value) => {
    setAssetFullScreen(value);
  }

  const classes = classNames('asset-browse', {
    'asset-browse-tree-collapse': !expandTree,
    'asset-browse-relation-collapse': !expandRelation,
  }); 
  
  const rightClasses = classNames('right', {
    'right-fullscreen': assetFullScreen
  }); 

  return (
    <div className={classes}>
      <ResizableBox 
          className='left' 
          width={230} 
          height={Infinity}
          axis='x'
          minConstraints={[230, Infinity]} maxConstraints={[Infinity, Infinity]}          
        >
        <AssetTree centerId={centerId} onSelect={onTreeSelect} reference={reference} {...props} />
      </ResizableBox>
      {
        expandTree && <Separate width={15} />
      }
      <div className={rightClasses}>
        {/* <AssetDirectory id={centerId} assetCount={assetCount} reference={reference} nodeType={nodeParams.nodeType} />
        <Separate height={15} /> */}
        <div className='flex' style={{ flex: 1, height: '100%', overflow: 'hidden' }}>
          {
            // expandRelation && <React.Fragment>
            //   <div style={{ flex: 1, height: '100%', overflow: 'hidden' }}>
            //     <RelationContainer reference={reference} nodeParams={nodeParams} onChange={onRelationChange} resize={resizeRelation} />
            //   </div>
            //   <Separate width={15} />
            // </React.Fragment>
          }
          <div style={{ flex: 1, overflow: 'hidden' }}>
            <AssetTable nodeId={centerId} nodeType={nodeParams.nodeType} reference={reference} onCountChange={onAssetCountChange} onFullScreenChange={onFullScreenChange} {...props} />
          </div>          
        </div>
        <div className='tree-toggle' onClick={treeToggleClick}>
        { expandTree ? <CaretLeftOutlined /> : <CaretRightOutlined /> }
        </div>
        {/* <div className='relation-toggle' onClick={relationToggleClick}>
          { expandRelation ? <CaretLeftOutlined /> : <CaretRightOutlined /> }
        </div> */}
      </div>
    </div>
  )
}

export default AssetBrowse;