import React, { useState } from 'react';
import classNames from 'classnames';
import { Form } from 'antd';
import { CaretLeftOutlined, CaretRightOutlined } from '@ant-design/icons';

import AssetTree from '../AssetManage/Component/AssetTree';
import AssetDirectory from '../AssetManage/Component/AssetDirectory';
import AssetTable from '../AssetManage/Component/AssetTable';
import AssetAction from '../AssetManage/Component/AssetAction';
import Separate from '../AssetManage/Component/Separate';

import { Asset1104ManageReference, AssetManageReference } from '../../../util/constant';

import '../AssetManage/index.less';

const Asset1104Manage = (props) => {

  const [ nodeId, setNodeId ] = useState('');
  const [ nodeType, setNodeType ] = useState('');
  const [ assetParams, setAssetParams ] = useState({ assetId: '', assetDirId: '' })
  const [ expandTree, setExpandTree ] = useState(true);

  const [ assetCount, setAssetCount ] = useState(0);
  const [ directoryChanged, setDirectoryChanged ] = useState(false);
  const [ elementsChanged, setElementsChanged ] = useState(false);
  const [ assetActionChanged, setAssetActionChanged ] = useState(false);
  const [ form ] = Form.useForm();

  const { assetId, assetDirId } = assetParams;

  const onTreeSelect = (value, type) => {
    setNodeId(value||'');
    setNodeType(type);
  }

  const onTableSelect = (id, did) => {
    setAssetParams({ assetId: id, assetDirId: did });
  }

  const treeToggleClick = () => {
    setExpandTree(!expandTree);
  }

  const onElementsChange = () => {
    setElementsChanged(!elementsChanged);
  }

  const onDirectoryChange = () => {
    setDirectoryChanged(!directoryChanged);
  }

  const onAssetActionChange = () => {
    setAssetActionChanged(!assetActionChanged);
  }

  const onAssetCountChange = (count) => {
    setAssetCount(count);
  }

  const classes = classNames('asset-manage', {
    'asset-manage-collapse': !expandTree
  });  

  return (
    <div className={classes}>
      <div className='left'>
        <AssetTree reference={Asset1104ManageReference} onSelect={onTreeSelect} onDirectoryChange={onDirectoryChange} {...props} />
      </div>
      {
        expandTree && <Separate width={15} />
      }
      <div className='middle'>
        <AssetDirectory id={nodeId} assetCount={assetCount} directoryChanged={directoryChanged} onElementsChange={onElementsChange} />
        <Separate height={15} />
        <AssetTable nodeId={nodeId} nodeType={nodeType} reference={AssetManageReference} elementsChanged={elementsChanged} assetActionChanged={assetActionChanged} onSelect={onTableSelect} onCountChange={onAssetCountChange} {...props} />
      </div>
      <Separate width='15px' />
      <div className='right'>
        <AssetAction form={form} id={assetId} dirId={assetDirId} action='detail' onChange={onAssetActionChange} />
      </div>
      <div className='tree-toggle' onClick={treeToggleClick}>
      { expandTree ? <CaretLeftOutlined /> : <CaretRightOutlined /> }
      </div>
    </div>
  )
}

export default Asset1104Manage;