import React, { Component } from "react";
import { connect } from 'react-redux';

import { GetSession } from '../../util';
import { HomeLayout } from '../../layout';

class Home extends Component {

  render() {
    const { session } = this.props;

    return (
      <React.Fragment>
        <HomeLayout {...this.props}
          content={(session && session.userId) ? (
            <div />
            )
            : <GetSession {...this.props} />}
        />
      </React.Fragment>
    );
  }
}

export default connect(
  state => {
    return { session: state.sessionState }
  }
)(Home);
