import { AxiosResponse } from "axios"

export default function (res: AxiosResponse<any>) {
  const blob = res.data
  const headers = res.headers

  let tempName = headers["content-disposition"]
    ?.split(";")?.[1]
    ?.split("filename=")?.[1];
  tempName = decodeURI(tempName);

  // const blob = new Blob([content], { type: 'application/octet-stream' })
  var url = (window.URL && window.URL.createObjectURL) ? window.URL.createObjectURL(blob) : window.webkitURL.createObjectURL(blob);
  const link = document.createElement('a');
  link.style.display = 'none';
  link.href = url;
  link.setAttribute('download', tempName); //or any other extension
  document.body.appendChild(link);
  link.click();
  URL.revokeObjectURL(link.href) // 释放URL 对象
  document.body.removeChild(link)
}