import React from "react"
import { Tree } from "antd"
import { Menu, Item, useContextMenu } from 'react-contexify'
import { generateUUID } from ".."

import 'react-contexify/dist/ReactContexify.css';

const FC = ({ shouldRowContextMenu, menuData, onMenuItemClick, ...restProps }) => {
  const MENU_ID = generateUUID()
  const { show } = useContextMenu({
    id: MENU_ID,
  })

  const [rightClickNode, setRightClickNode] = React.useState(undefined)

  const handleContextMenu = (event, node) => {
    show(event, {
      position: {
        x: event.clientX + 30,
        y: event.clientY - 10
      }
    })
  }

  return (
    <div>
      <Tree
        onRightClick={({event, node}) => {
          setRightClickNode(node)
          if (shouldRowContextMenu?.(node)) {
            handleContextMenu(event, node)
          } 
        }}
        {...restProps}
      />
       <Menu id={MENU_ID}>
       {
         menuData?.map(item => <Item key={item.id} id={item.id} onClick={() => onMenuItemClick?.(item.id, rightClickNode)}>{item.title}</Item>)
       }
      </Menu>
    </div>
  )
}

export default FC