import React, { useMemo } from 'react';
import { Tooltip } from 'antd';
import { Item as RcItem } from "react-contexify";

const FC = (props) => {
  const { permissionKey, permissions, defaultPermission, disabled, tip, children, ...restProps } = props;

  const havePermission = useMemo(() => {
    let _havePermission = true;
    
    if (defaultPermission===false) {
      _havePermission = defaultPermission;
    } else if (permissionKey) {
      const index = (permissions||[]).findIndex(item => item === permissionKey);
      _havePermission = (index !== -1);
    }
    
    return _havePermission;
  }, [permissionKey, permissions, defaultPermission])

  return (
    <RcItem disabled={!havePermission||disabled} {...restProps}>
      <Tooltip title={havePermission?tip:'暂无权限'}>
      {children}
      </Tooltip>
    </RcItem>
  )
}

export default FC;