import React, { useMemo } from 'react';
import { Tooltip, Menu } from 'antd';

const FC = (props) => {
  const { permissionKey, permissions, defaultPermission, disabled, tip, children, ...restProps } = props;

  const havePermission = useMemo(() => {
    let _havePermission = true;

    if (defaultPermission===false) {
      _havePermission = defaultPermission;
    } else if (permissionKey) {
      const index = (permissions||[]).findIndex(item => item === permissionKey);
      _havePermission = (index !== -1);
    }
    
    return _havePermission;
  }, [permissionKey, permissions, defaultPermission])

  return (
    <Menu.Item disabled={!havePermission||disabled} {...restProps}>
      <Tooltip title={havePermission?tip:'暂无权限'}>
      {children}
      </Tooltip>
    </Menu.Item>
  )
}

export default FC;